/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LayerLightEngine;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;

public class SlimeNyliumBlock
extends Block
implements BonemealableBlock {
    private final SlimeType foliageType;

    public SlimeNyliumBlock(BlockBehaviour.Properties properties, SlimeType foliageType) {
        super(properties);
        this.foliageType = foliageType;
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.foliageType != SlimeType.ICHOR) {
            super.m_49811_(group, items);
        }
    }

    private static boolean isDarkEnough(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = reader.m_8055_(blockpos);
        int i = LayerLightEngine.m_75667_((BlockGetter)reader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)reader, blockpos));
        return i < reader.m_7469_();
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (!SlimeNyliumBlock.isDarkEnough(state, (LevelReader)worldIn, pos)) {
            worldIn.m_46597_(pos, SlimeGrassBlock.getDirtState(state));
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel world, Random rand, BlockPos pos, BlockState state) {
        SlimeGrassBlock.growGrass(world, rand, pos, TinkerTags.Blocks.SLIMY_NYLIUM, this.foliageType, true, true);
    }
}

