/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.client;

import java.io.IOException;
import net.minecraft.client.resources.LegacyStuffWrapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModLoader;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class SlimeColorReloadListener
extends SimplePreparableReloadListener<int[]> {
    private final SlimeType color;
    private final ResourceLocation path;

    public SlimeColorReloadListener(SlimeType color) {
        this.color = color;
        this.path = TConstruct.getResource("textures/colormap/" + color.m_7912_() + "_grass_color.png");
    }

    protected int[] prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        if (!ModLoader.isLoadingStateValid()) {
            return new int[0];
        }
        try {
            return LegacyStuffWrapper.m_118726_((ResourceManager)resourceManager, (ResourceLocation)this.path);
        }
        catch (IOException ioexception) {
            TConstruct.LOG.error("Failed to load slime colors", (Throwable)ioexception);
            return new int[0];
        }
    }

    protected void apply(int[] buffer, ResourceManager resourceManager, ProfilerFiller profiler) {
        if (buffer.length != 0) {
            SlimeColorizer.setGrassColor(this.color, buffer);
        }
    }
}

