/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.entity.ArmoredSlimeEntity;

public class SkySlimeEntity
extends ArmoredSlimeEntity {
    private double bounceAmount = 0.0;

    public SkySlimeEntity(EntityType<? extends SkySlimeEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected float m_6118_() {
        return (float)Math.sqrt(this.m_33632_()) * this.m_20098_() / 2.0f;
    }

    protected ParticleOptions m_6300_() {
        return (ParticleOptions)TinkerWorld.skySlimeParticle.get();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (this.m_20162_()) {
            return super.m_142535_(distance, damageMultiplier * 0.2f, source);
        }
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        if (distance > 2.0f) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_ / (double)0.95f, motion.f_82480_ * -0.9, motion.f_82481_ / (double)0.95f);
            this.bounceAmount = this.m_20184_().f_82480_;
            this.f_19789_ = 0.0f;
            this.f_19812_ = true;
            this.m_6853_(false);
            this.m_5496_(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
        }
        return false;
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        if (this.bounceAmount > 0.0) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, this.bounceAmount, motion.f_82481_);
            this.bounceAmount = 0.0;
        }
    }

    @Override
    protected void m_6851_(DifficultyInstance difficulty) {
        float multiplier = difficulty.m_19057_();
        if (this.f_19796_.nextFloat() < 0.15f * multiplier) {
            boolean isPlate = this.f_19796_.nextFloat() < 0.05f * multiplier;
            ItemStack helmet = new ItemStack((ItemLike)(isPlate ? TinkerTools.plateArmor : TinkerTools.travelersGear).get((Enum)ArmorSlotType.HELMET));
            ToolStack tool = ToolStack.from(helmet);
            tool.ensureSlotsBuilt();
            ModifierNBT modifiers = tool.getUpgrades();
            ModDataNBT persistentData = tool.getPersistentData();
            if (!isPlate) {
                persistentData.putInt(TinkerModifiers.dyed.getId(), this.f_19796_.nextInt(0x1000000));
                modifiers = modifiers.withModifier(TinkerModifiers.dyed.getId(), 1);
            }
            int max = tool.getFreeSlots(SlotType.DEFENSE);
            for (int i = 0; i < max && !(this.f_19796_.nextFloat() > 0.5f * multiplier); ++i) {
                persistentData.addSlots(SlotType.DEFENSE, -1);
                modifiers = modifiers.withModifier(SkySlimeEntity.randomDefense(this.f_19796_.nextInt(6)), 1);
            }
            if (tool.getFreeSlots(SlotType.UPGRADE) > 0 && this.f_19796_.nextFloat() < 0.5f * multiplier) {
                persistentData.addSlots(SlotType.UPGRADE, -1);
                modifiers = modifiers.withModifier(this.f_19796_.nextBoolean() ? ModifierIds.emerald : ModifierIds.diamond, 1);
            }
            tool.setUpgrades(modifiers);
            this.m_8061_(EquipmentSlot.HEAD, helmet);
        }
    }

    private static ModifierId randomDefense(int index) {
        return switch (index) {
            default -> TinkerModifiers.meleeProtection.getId();
            case 1 -> TinkerModifiers.projectileProtection.getId();
            case 2 -> TinkerModifiers.fireProtection.getId();
            case 3 -> TinkerModifiers.magicProtection.getId();
            case 4 -> TinkerModifiers.blastProtection.getId();
            case 5 -> TinkerModifiers.golden.getId();
        };
    }

    @Override
    protected void m_6850_(DifficultyInstance difficulty) {
    }
}

