/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.tile.IndustrialGeneratorTile;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.worlddata.MycelialDataManager;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MycelialReactorTile
extends IndustrialGeneratorTile<MycelialReactorTile> {
    @Save
    private String owner;
    private ProgressBarComponent<MycelialReactorTile> bar;

    public MycelialReactorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleGenerator.MYCELIAL_REACTOR, blockPos, blockState);
    }

    @Nonnull
    public MycelialReactorTile getSelf() {
        return this;
    }

    public int consumeFuel() {
        MycelialDataManager.getReactorAvailable(this.owner, this.f_58857_, true);
        return 5;
    }

    public boolean canStart() {
        int amount = MycelialDataManager.getReactorAvailable(this.owner, this.f_58857_, false).size();
        if (amount == IMycelialGeneratorType.TYPES.size()) {
            MycelialDataManager.getReactorAvailable(this.owner, this.f_58857_, true);
            return true;
        }
        this.markForUpdate();
        return false;
    }

    public int getEnergyProducedEveryTick() {
        return 25000000;
    }

    public ProgressBarComponent<MycelialReactorTile> getProgressBar() {
        this.bar = new ProgressBarComponent<MycelialReactorTile>(30, 20, 0, 100){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon(30, 20, MycelialReactorTile.this.bar){

                    @OnlyIn(value=Dist.CLIENT)
                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + new TranslatableComponent("tooltip.titanium.progressbar.progress").getString() + ChatFormatting.WHITE + new DecimalFormat().format(MycelialReactorTile.this.bar.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(MycelialReactorTile.this.bar.getMaxProgress())));
                        int progress = MycelialReactorTile.this.bar.getMaxProgress() - MycelialReactorTile.this.bar.getProgress();
                        if (!MycelialReactorTile.this.bar.getIncreaseType()) {
                            progress = MycelialReactorTile.this.bar.getMaxProgress() - progress;
                        }
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "ETA: " + ChatFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * MycelialReactorTile.this.bar.getTickingTime()) / 20.0 / (double)MycelialReactorTile.this.bar.getProgressIncrease())) + ChatFormatting.DARK_AQUA + "s"));
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + new TranslatableComponent("tooltip.industrialforegoing.generating").getString() + ChatFormatting.WHITE + new DecimalFormat().format(MycelialReactorTile.this.getEnergyProducedEveryTick()) + ChatFormatting.DARK_AQUA + " FE" + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + ChatFormatting.DARK_AQUA + "t"));
                        return tooltip;
                    }
                });
            }
        }.setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
        return this.bar;
    }

    public int getEnergyCapacity() {
        return 100000000;
    }

    public int getExtractingEnergy() {
        return this.getEnergyCapacity();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ProgressBarComponent<MycelialReactorTile> getBar() {
        return this.bar;
    }
}

