/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.TextGuiComponent;
import com.buuz135.industrial.gui.component.custom.TextureGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.network.ConveyorSplittingSyncEntityMessage;
import com.buuz135.industrial.utils.MovementUtils;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class ConveyorSplittingUpgrade
extends ConveyorUpgrade {
    public static VoxelShape NORTH = Shapes.m_83048_((double)0.295, (double)0.1, (double)-0.08000000000000002, (double)0.6950000000000001, (double)0.16, (double)0.29999999999999993);
    public static VoxelShape SOUTH = Shapes.m_83048_((double)0.295, (double)0.1, (double)0.7, (double)0.6950000000000001, (double)0.16, (double)1.08);
    public static VoxelShape WEST = Shapes.m_83048_((double)-0.08, (double)0.1, (double)0.3, (double)0.3, (double)0.16, (double)0.7);
    public static VoxelShape EAST = Shapes.m_83048_((double)0.7, (double)0.1, (double)0.3, (double)1.07, (double)0.16, (double)0.7);
    public List<Integer> handlingEntities = new ArrayList<Integer>();
    private Direction nextFacing;
    private int ratio;
    private int currentRatio;

    public ConveyorSplittingUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
        this.nextFacing = side;
        this.ratio = 1;
        this.currentRatio = 1;
    }

    @Override
    public void handleEntity(Entity entity) {
        super.handleEntity(entity);
        if (!this.getWorld().f_46443_ && !this.getContainer().getEntityFilter().contains(entity.m_142049_()) && this.nextFacing == this.getSide()) {
            this.handlingEntities.add(entity.m_142049_());
            this.getContainer().getEntityFilter().add(entity.m_142049_());
            IndustrialForegoing.NETWORK.sendToNearby(this.getContainer().getBlockWorld(), this.getPos(), 64, (Message)new ConveyorSplittingSyncEntityMessage(this.getPos(), entity.m_142049_(), this.getSide()));
            this.findNextUpgradeAndUpdate();
        }
        if (this.handlingEntities.contains(entity.m_142049_())) {
            MovementUtils.handleConveyorMovement(entity, this.getSide(), this.getPos(), ((ConveyorTile)this.getContainer()).getConveyorType());
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.handlingEntities.isEmpty()) {
            return;
        }
        AABB box = ((AABB)this.getWorld().m_8055_(this.getPos()).m_60812_((BlockGetter)this.getWorld(), this.getPos()).m_83299_().get(0)).m_82338_(this.getPos()).m_82400_(0.04);
        for (Integer integer : new ArrayList<Integer>(this.handlingEntities)) {
            Entity entity = this.getWorld().m_6815_(integer.intValue());
            if (entity == null || box.m_82381_(entity.m_142469_())) continue;
            this.handlingEntities.remove(integer);
            this.getContainer().getEntityFilter().remove(integer);
        }
    }

    @Override
    public void onUpgradeRemoved() {
        super.onUpgradeRemoved();
        if (this.nextFacing == this.getSide()) {
            this.findNextUpgradeAndUpdate();
        }
    }

    public void findNextUpgradeAndUpdate() {
        int y;
        --this.currentRatio;
        if (this.currentRatio > 0) {
            this.getContainer().requestSync();
            return;
        }
        this.currentRatio = this.ratio;
        Direction facing = this.nextFacing.m_122427_();
        ConveyorUpgrade conveyorUpgrade = ((ConveyorTile)this.getContainer()).getUpgradeMap().get(facing);
        for (y = 0; !(conveyorUpgrade instanceof ConveyorSplittingUpgrade) && y < 10; ++y) {
            facing = facing.m_122427_();
            conveyorUpgrade = ((ConveyorTile)this.getContainer()).getUpgradeMap().get(facing);
        }
        if (y >= 10) {
            facing = this.getSide();
        }
        ConveyorTile entityConveyor = (ConveyorTile)this.getContainer();
        for (Direction Direction2 : entityConveyor.getUpgradeMap().keySet()) {
            ConveyorUpgrade upgrade = entityConveyor.getUpgradeMap().get(Direction2);
            if (!(upgrade instanceof ConveyorSplittingUpgrade)) continue;
            ((ConveyorSplittingUpgrade)upgrade).setNextFacing(facing);
        }
        this.getContainer().requestSync();
    }

    @Override
    public boolean ignoresCollision() {
        return true;
    }

    @Override
    public VoxelShape getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: 
        }
        return EAST;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT() == null ? new CompoundTag() : super.serializeNBT();
        compound.m_128359_("NextFacing", this.nextFacing.m_7912_());
        compound.m_128405_("Ratio", this.ratio);
        compound.m_128405_("CurrentRatio", this.currentRatio);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.nextFacing = Direction.m_122402_((String)nbt.m_128461_("NextFacing"));
        this.ratio = nbt.m_128451_("Ratio");
        this.currentRatio = nbt.m_128451_("CurrentRatio");
    }

    public Direction getNextFacing() {
        return this.nextFacing;
    }

    public void setNextFacing(Direction nextFacing) {
        this.nextFacing = nextFacing;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TextureGuiComponent(20, 26, 16, 16, res, 40, 234, "splitting_ratio"));
        componentList.add(new TextGuiComponent(40, 31){

            @Override
            public String getText() {
                return ChatFormatting.DARK_GRAY + (ConveyorSplittingUpgrade.this.ratio < 10 ? " " : "") + ConveyorSplittingUpgrade.this.ratio;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(0, 60, 26, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(1, 76, 26, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId == 0 && this.ratio <= 64) {
            ++this.ratio;
            this.currentRatio = this.ratio;
            this.getContainer().requestSync();
        }
        if (buttonId == 1 && this.ratio > 1) {
            --this.ratio;
            this.currentRatio = this.ratio;
            this.getContainer().requestSync();
        }
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("splitting");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorSplittingUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_splitting_" + upgradeSide.m_7912_().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_splitting_upgrade");
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).m_126130_("IPI").m_126130_("IDI").m_126130_("ICI").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get()).m_126127_(Character.valueOf('D'), (ItemLike)Blocks.f_50332_).m_126127_(Character.valueOf('C'), (ItemLike)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get()).m_176498_(consumer);
        }
    }
}

