/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import com.google.common.base.Strings;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFuelRodEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ReactorControlRodEntity
extends AbstractReactorEntity
implements MenuProvider {
    public static String COMMAND_SET_NAME = "setname";
    public static String COMMAND_SET_INSERTION = "setinsertion";
    private String _name = "";
    private byte _insertionRatio = 0;

    public ReactorControlRodEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.REACTOR_CONTROLROD.get(), position, blockState);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(COMMAND_SET_NAME, ReactorControlRodEntity::setNameFromGUI).addServerHandler(COMMAND_SET_INSERTION, ReactorControlRodEntity::setInsertionFromGUI).build((AbstractModBlockEntity)this));
    }

    public void linkToFuelRods(int fuelRodsCount) {
        CodeHelper.optionalIfPresent((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (world, direction) -> this.linkToFuelRods((Level)world, direction.m_122424_(), fuelRodsCount));
    }

    private void linkToFuelRods(Level world, Direction direction, int fuelRodsCount) {
        BlockPos lookupPosition = this.getWorldPosition();
        for (int i = 0; i < fuelRodsCount; ++i) {
            int rodIndex = fuelRodsCount - i - 1;
            lookupPosition = lookupPosition.m_142300_(direction);
            CodeHelper.optionalIfPresentOrThrow(WorldHelper.getTile((Level)world, (BlockPos)lookupPosition).filter(te -> te instanceof ReactorFuelRodEntity).map(te -> (ReactorFuelRodEntity)te), rod -> rod.linkToControlRod(this, rodIndex));
        }
    }

    public FuelRodsLayout getFuelRodsLayout() {
        return (FuelRodsLayout)this.evalOnController(IReactorReader::getFuelRodsLayout, FuelRodsLayout.EMPTY);
    }

    public String getName() {
        return this._name;
    }

    public byte getInsertionRatio() {
        return this._insertionRatio;
    }

    public float getInsertionPercentage() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.getInsertionRatio() / 100.0f));
    }

    public static void setName(ReactorControlRodEntity controlRod, String newName) {
        if (controlRod.setName(newName)) {
            controlRod.notifyBlockUpdate();
        }
    }

    public static void setInsertionRatio(ReactorControlRodEntity controlRod, int newRatio) {
        if (controlRod.setInsertionRatio(newRatio)) {
            controlRod.notifyBlockUpdate();
        }
    }

    public static void changeInsertionRatio(ReactorControlRodEntity controlRod, int delta) {
        if (controlRod.setInsertionRatio(controlRod.getInsertionRatio() + delta)) {
            controlRod.notifyBlockUpdate();
        }
    }

    public static void setInsertionRatio(Collection<ReactorControlRodEntity> controlRods, int newRatio) {
        Set updated = controlRods.stream().filter(IMultiblockPart::isConnected).filter(rod -> rod.setInsertionRatio(newRatio)).collect(Collectors.toSet());
        if (!updated.isEmpty()) {
            AbstractModBlockEntity.notifyBlockUpdate(updated);
        }
    }

    public static void changeInsertionRatio(Collection<ReactorControlRodEntity> controlRods, int delta) {
        Set updated = controlRods.stream().filter(IMultiblockPart::isConnected).filter(rod -> rod.setInsertionRatio(rod.getInsertionRatio() + delta)).collect(Collectors.toSet());
        if (!updated.isEmpty()) {
            AbstractModBlockEntity.notifyBlockUpdate(updated);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return ModTileContainer.empty((MenuType)((MenuType)Content.ContainerTypes.REACTOR_CONTROLROD.get()), (int)windowId, (AbstractModBlockEntity)this, (ServerPlayer)((ServerPlayer)player));
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (data.m_128441_("rodInsertion")) {
            this.setInsertionRatio(data.m_128445_("rodInsertion"));
        }
        if (data.m_128441_("rodName")) {
            this.setName(data.m_128461_("rodName"));
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.m_128344_("rodInsertion", this.getInsertionRatio());
        data.m_128359_("rodName", this.getName());
        return data;
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (position.isFace()) {
            if (position.getDirection().map(direction -> this.checkForFuelRod(direction.m_122424_())).orElse(false).booleanValue()) {
                return true;
            }
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reactor.invalid_control_rods_position", new Object[0]);
            return false;
        }
        return super.isGoodForPosition(position, validatorCallback);
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    private void setInsertionFromGUI(CompoundTag data) {
        if (data.m_128441_("v")) {
            if (data.m_128471_("all")) {
                this.getMultiblockController().ifPresent(c -> c.setControlRodsInsertionRatio(data.m_128451_("v")));
            } else {
                this.setInsertionRatio(data.m_128451_("v"));
            }
        }
    }

    private void setNameFromGUI(CompoundTag data) {
        if (data.m_128441_("name")) {
            this.setName(data.m_128461_("name"));
        }
    }

    private boolean setInsertionRatio(int newRatio) {
        if (this.getInsertionRatio() == newRatio || newRatio < 0 || newRatio > 100) {
            return false;
        }
        this._insertionRatio = (byte)newRatio;
        this.m_6596_();
        this.notifyBlockUpdate();
        return true;
    }

    private boolean setName(String newName) {
        if (Strings.isNullOrEmpty((String)newName) || this.getName().equals(newName)) {
            return false;
        }
        this._name = newName;
        this.m_6596_();
        this.notifyBlockUpdate();
        return true;
    }

    private boolean checkForFuelRod(Direction rodDirection) {
        return (Boolean)this.mapPartWorld(world -> WorldHelper.getLoadedTile((Level)world, (BlockPos)this.getWorldPosition().m_142300_(rodDirection)) instanceof ReactorFuelRodEntity, false);
    }
}

