/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen;

import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.ModTileContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SlotsGroup;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullSupplier;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractScreen<T extends AbstractModBlockEntity, C extends ModTileContainer<T>>
extends ModTileContainerScreen<T, C> {
    public static final int DEFAULT_GUI_WIDTH = 224;
    public static final int DEFAULT_GUI_HEIGHT = 166;
    public static final Style STYLE_TOOLTIP_TITLE = Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true));
    public static final Style STYLE_TOOLTIP_VALUE = Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA).m_131136_(Boolean.valueOf(true));
    public static final Style STYLE_TOOLTIP_INFO = Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE).m_131155_(Boolean.valueOf(true));
    private static final int TITLE_PANEL_HEIGHT = 21;
    private final ISpriteTextureMap _mainTextMap;
    private final ISprite _invMainSprite;
    private final ISprite _invHotBarSprite;
    private final ISprite _invSingleSprite;
    private final IControlContainer _contentPanel;
    private IControl _helpButton;

    protected AbstractScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, NonNullSupplier<SpriteTextureMap> mainTextureSupplier) {
        this(container, inventory, inventoryUsage, title, 224, 166, (SpriteTextureMap)mainTextureSupplier.get());
    }

    protected AbstractScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, int guiWidth, int guiHeight, NonNullSupplier<SpriteTextureMap> mainTextureSupplier) {
        this(container, inventory, inventoryUsage, title, guiWidth, guiHeight, (SpriteTextureMap)mainTextureSupplier.get());
    }

    protected AbstractScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, int guiWidth, int guiHeight, SpriteTextureMap mainTexture) {
        super(container, inventory, title, guiWidth, guiHeight);
        this._mainTextMap = mainTexture;
        switch (inventoryUsage) {
            default: {
                this._invHotBarSprite = this._invSingleSprite = Sprite.EMPTY;
                this._invMainSprite = this._invSingleSprite;
                break;
            }
            case HotBar: {
                this._invHotBarSprite = this.createInventoryHotBarSprite();
                this._invMainSprite = Sprite.EMPTY;
                this._invSingleSprite = this.createInventorySingleSprite();
                break;
            }
            case MainInventory: {
                this._invHotBarSprite = Sprite.EMPTY;
                this._invMainSprite = this.createInventoryMainSprite();
                this._invSingleSprite = this.createInventorySingleSprite();
                break;
            }
            case Both: {
                this._invHotBarSprite = this.createInventoryHotBarSprite();
                this._invMainSprite = this.createInventoryMainSprite();
                this._invSingleSprite = this.createInventorySingleSprite();
            }
        }
        this._contentPanel = new Panel(this, "content");
        this._helpButton = null;
    }

    protected void addControl(IControl control) {
        this._contentPanel.addControl(control);
    }

    protected void setContentPanelBackground(ISprite sprite) {
        this._contentPanel.setBackground(sprite);
    }

    protected void setContentPanelBackground(Colour colour) {
        this._contentPanel.setBackground(colour);
    }

    protected void setContentLayoutEngine(ILayoutEngine engine) {
        this._contentPanel.setLayoutEngine(engine);
    }

    protected void addPatchouliHelpButton(ResourceLocation bookId, ResourceLocation entryId, int pageNum) {
        this._helpButton = this.createPatchouliHelpButton(bookId, entryId, pageNum);
    }

    protected void setButtonSpritesAndOverlayForState(AbstractButtonControl button, ButtonState standardState, NonNullSupplier<ISprite> standardSprite) {
        this.setButtonSpritesAndOverlayForState(button, standardState, (ISprite)standardSprite.get());
    }

    protected void setButtonSpritesAndOverlayForState(AbstractButtonControl button, ButtonState standardState, ISprite standardSprite) {
        button.setIconForState(standardSprite, standardState);
        ISprite withOverlay = standardSprite.copyWith(BaseIcons.Button16x16HightlightOverlay.get());
        button.setIconForState(withOverlay, standardState.getHighlighted());
        withOverlay = standardSprite.copyWith(BaseIcons.Button16x16DisabledOverlay.get());
        button.setIconForState(withOverlay, standardState.getDisabled());
    }

    @Nullable
    protected IControl getTitleBarWidget() {
        return null;
    }

    protected SlotsGroup createSingleSlotGroupControl(String controlName, String inventorySlotsGroupName) {
        return this.createMonoSlotGroupControl(controlName, inventorySlotsGroupName, this._invSingleSprite, 1);
    }

    protected SlotsGroup createPlayerHotBarSlotsGroupControl() {
        return this.createPlayerHotBarSlotsGroupControl(this._invHotBarSprite, 1);
    }

    protected SlotsGroup createPlayerInventorySlotsGroupControl() {
        return this.createPlayerInventorySlotsGroupControl(this._invMainSprite, 1);
    }

    @Override
    protected void onScreenCreate() {
        super.onScreenCreate();
        int guiWidth = this.getGuiWidth();
        int guiHeight = this.getGuiHeight();
        Panel mainPanel = new Panel(this, "mainPanel");
        Panel titlePanel = new Panel(this, "titlePanel");
        int contentHeight = guiHeight - 21;
        mainPanel.setDesiredDimension(DesiredDimension.Height, guiHeight);
        mainPanel.setDesiredDimension(DesiredDimension.Width, guiWidth);
        mainPanel.setLayoutEngineHint(FixedLayoutEngine.hint(0, 0, guiWidth, guiHeight));
        mainPanel.setBackground(this._mainTextMap.sprite().ofSize(guiWidth, guiHeight).build());
        mainPanel.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine().setZeroMargins());
        titlePanel.setDesiredDimension(DesiredDimension.Height, 21);
        titlePanel.setDesiredDimension(DesiredDimension.Width, guiWidth);
        titlePanel.setLayoutEngineHint(FixedLayoutEngine.hint(0, 0, guiWidth, 21));
        titlePanel.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine().setZeroMargins());
        IControl titleWidget = this.getTitleBarWidget();
        int titlePosX = 7;
        int titleWidth = guiWidth - 14;
        if (null != titleWidget) {
            titleWidget.setLayoutEngineHint(FixedLayoutEngine.hint(7, 7, 10, 10));
            titlePanel.addControl(titleWidget);
            titlePosX += 10;
            titleWidth -= 10;
        }
        if (null != this._helpButton) {
            this._helpButton.setLayoutEngineHint(FixedLayoutEngine.hint(guiWidth - 18, 6, 12, 12));
            titlePanel.addControl(this._helpButton);
            titleWidth -= 12;
        }
        Label title = new Label((ModContainerScreen<? extends ModContainer>)this, "title", this.m_96636_());
        title.setPadding(2);
        title.setColor(this.getTheme().GUI_TITLE);
        title.setAutoSize(false);
        title.setLayoutEngineHint(FixedLayoutEngine.hint(titlePosX, 7, titleWidth, 12));
        titlePanel.addControl((IControl)title);
        this._contentPanel.removeControls();
        this._contentPanel.setLayoutEngine(new FixedLayoutEngine());
        this._contentPanel.setDesiredDimension(DesiredDimension.Height, contentHeight);
        this._contentPanel.setDesiredDimension(DesiredDimension.Width, guiWidth);
        this._contentPanel.setLayoutEngineHint(FixedLayoutEngine.hint(0, 21, guiWidth, contentHeight));
        mainPanel.addControl(titlePanel, this._contentPanel);
        this.createWindow(mainPanel, true);
    }

    private ISprite createInventoryHotBarSprite() {
        return this._mainTextMap.sprite().from(0, 202).ofSize(162, 18).build();
    }

    private ISprite createInventoryMainSprite() {
        return this._mainTextMap.sprite().from(0, 202).ofSize(162, 54).build();
    }

    private ISprite createInventorySingleSprite() {
        return this._mainTextMap.sprite().from(0, 202).ofSize(18, 18).build();
    }
}

