/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class AbstractSwitchableButtonControl
extends AbstractButtonControl {
    private boolean _active;
    private final boolean _grouped;
    private final Consumer<AbstractSwitchableButtonControl> _buttonGroupNotify;

    public AbstractSwitchableButtonControl(ModContainerScreen<? extends ModContainer> gui, String name, String text, boolean active) {
        this(gui, name, text, active, null);
    }

    public AbstractSwitchableButtonControl(ModContainerScreen<? extends ModContainer> gui, String name, String text, boolean active, @Nullable String groupName) {
        super(gui, name, text);
        this._active = active;
        if (Strings.isNullOrEmpty((String)groupName)) {
            this._grouped = false;
            this._buttonGroupNotify = b -> {};
        } else {
            this._grouped = true;
            this._buttonGroupNotify = ButtonGroup.linkToGroup(groupName, this);
        }
    }

    public boolean getActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        if (this._active == active) {
            return;
        }
        this._active = active;
        if (active) {
            this._buttonGroupNotify.accept(this);
            this.onActivated();
        } else {
            this.onDeactivated();
        }
    }

    protected abstract void onActivated();

    protected abstract void onDeactivated();

    @Override
    public boolean onMouseClicked(IWindow wnd, int mouseX, int mouseY, int clickedButton) {
        super.onMouseClicked(wnd, mouseX, mouseY, clickedButton);
        if (this._grouped) {
            if (!this.getActive()) {
                this.setActive(true);
            }
        } else {
            this.setActive(!this.getActive());
        }
        return true;
    }

    @Override
    protected ButtonState getButtonState() {
        if (!this.getEnabled()) {
            return this.getActive() ? ButtonState.ActiveDisabled : ButtonState.DefaultDisabled;
        }
        if (this.getActive()) {
            return this.getMouseOver() ? ButtonState.ActiveHighlighted : ButtonState.Active;
        }
        return this.getMouseOver() ? ButtonState.DefaultHighlighted : ButtonState.Default;
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" active:").append(this._active).append(" grouped:").append(this._grouped);
    }

    static class ButtonGroup {
        private final List<AbstractSwitchableButtonControl> _buttons = Lists.newArrayList();
        private static final Map<ModContainerScreen<? extends ModContainer>, Map<String, ButtonGroup>> s_buttonGroups = Maps.newHashMap();

        public static Consumer<AbstractSwitchableButtonControl> linkToGroup(String groupName, AbstractSwitchableButtonControl button) {
            ButtonGroup group = s_buttonGroups.computeIfAbsent(button.getGui(), gui -> {
                gui.Close.subscribe(() -> {
                    Map<String, ButtonGroup> removed = s_buttonGroups.remove(gui);
                    removed.values().forEach(ButtonGroup::clear);
                    removed.clear();
                });
                return Maps.newHashMap();
            }).computeIfAbsent(groupName, k -> new ButtonGroup());
            group.addButton(button);
            return group::onActivated;
        }

        public void onActivated(AbstractSwitchableButtonControl selectedButton) {
            this._buttons.stream().filter(button -> selectedButton != button).forEach(button -> button.setActive(false));
        }

        void addButton(AbstractSwitchableButtonControl button) {
            this._buttons.add(button);
        }

        void clear() {
            this._buttons.clear();
        }
    }
}

