/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.mojang.blaze3d.vertex.PoseStack;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractCompositeControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.UpDown;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class NumberInput<Type>
extends AbstractCompositeControl
implements NonNullSupplier<Type> {
    public final IEvent<BiConsumer<NumberInput<Type>, Type>> Changed;
    private final UpDown _updown;
    private final Label _label;
    private String _formatString;
    private String _paintingSuffix;

    public void setFormatString(@Nullable String formatString) {
        this._formatString = formatString;
        this.updateLabel();
    }

    public void setDisplaySuffix(@Nullable String suffix) {
        this._paintingSuffix = suffix;
        this.updateLabel();
    }

    public Colour getColor() {
        return this._label.getColor();
    }

    public void setColor(Colour color) {
        this._label.setColor(color);
    }

    public Colour getDisabledColor() {
        return this._label.getDisabledColor();
    }

    public void setDisabledColor(Colour color) {
        this._label.setDisabledColor(color);
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this._label.getHorizontalAlignment();
    }

    public void setHorizontalAlignment(HorizontalAlignment alignment) {
        this._label.setHorizontalAlignment(alignment);
    }

    public VerticalAlignment getVerticalAlignment() {
        return this._label.getVerticalAlignment();
    }

    public void setVerticalAlignment(VerticalAlignment alignment) {
        this._label.setVerticalAlignment(alignment);
    }

    protected abstract void increment(BooleanSupplier var1, BooleanSupplier var2);

    protected abstract void decrement(BooleanSupplier var1, BooleanSupplier var2);

    protected abstract String getAsString();

    @Override
    public void onWindowClosed() {
        super.onWindowClosed();
        this.Changed.unsubscribeAll();
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        Padding padding = this.getPadding();
        int h = bounds.Height - padding.getBottom() - padding.getTop();
        int valueWidth = bounds.Width - h - padding.getRight() * 2 - padding.getLeft();
        this._label.setBounds(new Rectangle(padding.getLeft(), padding.getTop(), valueWidth, h));
        this._updown.setBounds(new Rectangle(valueWidth + padding.getLeft() + padding.getRight(), padding.getTop(), h, h));
    }

    @Override
    public void onPaintBackground(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        super.onPaintBackground(matrix, partialTicks, mouseX, mouseY);
        this.paintHollowRect(matrix, 0, 0, this.getBounds().Width, this.getBounds().Height, this.getTheme().DARK_OUTLINE_COLOR);
    }

    protected NumberInput(ModContainerScreen<? extends ModContainer> gui, String name) {
        super(gui, name);
        this._updown = new UpDown(gui, "ud");
        this._updown.Clicked.subscribe(this::changeSelection);
        this._label = new Label(gui, "value", "0");
        this._label.setAutoSize(false);
        this.setPadding(3, 2, 2, 2);
        this.setBackground(this.getTheme().FLAT_BACKGROUND_COLOR);
        this.addChildControl(this._label, this._updown);
        this.Changed = new Event<BiConsumer<NumberInput<Type>, Type>>();
    }

    private void changeSelection(Direction.AxisDirection changeDirection, Integer buttonClicked) {
        switch (changeDirection) {
            case POSITIVE: {
                this.increment(Screen::m_96637_, Screen::m_96638_);
                break;
            }
            case NEGATIVE: {
                this.decrement(Screen::m_96637_, Screen::m_96638_);
            }
        }
        this.updateLabel();
        this.Changed.raise(c -> c.accept(this, this.get()));
    }

    protected void updateLabel() {
        this._label.setText(this.suffixedText());
    }

    private String suffixedText() {
        return null != this._paintingSuffix ? this.formattedText() + this._paintingSuffix : this.formattedText();
    }

    private String formattedText() {
        return null != this._formatString ? String.format(this._formatString, this.get()) : this.getAsString();
    }

    public static class DoubleNumberInput
    extends NumberInput<Double> {
        private double _value;
        private double _step;
        private double _largeStep;
        private double _min;
        private double _max;

        public DoubleNumberInput(ModContainerScreen<? extends ModContainer> gui, String name, double value) {
            this(gui, name, 1.4E-45f, 3.4028234663852886E38, value);
        }

        public DoubleNumberInput(ModContainerScreen<? extends ModContainer> gui, String name, double min, double max, double value) {
            super(gui, name);
            this._min = min;
            this._max = max;
            this.setValue(value);
        }

        public void setValue(double value) {
            this._value = Mth.m_14008_((double)value, (double)this._min, (double)this._max);
            this.updateLabel();
        }

        public void setMinValue(double min) {
            this._min = min;
            this._value = Mth.m_14008_((double)this._value, (double)this._min, (double)this._max);
            this.updateLabel();
        }

        public void setMaxValue(double max) {
            this._max = max;
            this._value = Mth.m_14008_((double)this._value, (double)this._min, (double)this._max);
            this.updateLabel();
        }

        public void setStep(double standard, double large) {
            this._step = standard;
            this._largeStep = large;
        }

        public void setStep(double step) {
            this._step = this._largeStep = step;
        }

        public double getStandardStep() {
            return this._step;
        }

        public double getLargeStep() {
            return this._largeStep;
        }

        @Override
        protected void increment(BooleanSupplier useLargeStep, BooleanSupplier toMax) {
            if (toMax.getAsBoolean()) {
                this._value = this._max;
            } else {
                double step = useLargeStep.getAsBoolean() ? this._largeStep : this._step;
                double v = this.getAsDouble();
                this._value = v <= this._max - step ? v + step : this._max;
            }
        }

        @Override
        protected void decrement(BooleanSupplier useLargeStep, BooleanSupplier toMin) {
            if (toMin.getAsBoolean()) {
                this._value = this._min;
            } else {
                double step = useLargeStep.getAsBoolean() ? this._largeStep : this._step;
                double v = this.getAsDouble();
                this._value = v >= this._min + step ? v - step : this._min;
            }
        }

        @Override
        protected String getAsString() {
            return Double.toString(this.getAsDouble());
        }

        public Double get() {
            return this._value;
        }

        public double getAsDouble() {
            return this._value;
        }
    }

    public static class FloatNumberInput
    extends NumberInput<Float> {
        private float _value;
        private float _step;
        private float _largeStep;
        private float _min;
        private float _max;

        public FloatNumberInput(ModContainerScreen<? extends ModContainer> gui, String name, float value) {
            this(gui, name, Float.MIN_VALUE, Float.MAX_VALUE, value);
        }

        public FloatNumberInput(ModContainerScreen<? extends ModContainer> gui, String name, float min, float max, float value) {
            super(gui, name);
            this._min = min;
            this._max = max;
            this.setValue(value);
        }

        public void setValue(float value) {
            this._value = Mth.m_14036_((float)value, (float)this._min, (float)this._max);
            this.updateLabel();
        }

        public void setMinValue(float min) {
            this._min = min;
            this._value = Mth.m_14036_((float)this._value, (float)this._min, (float)this._max);
            this.updateLabel();
        }

        public void setMaxValue(float max) {
            this._max = max;
            this._value = Mth.m_14036_((float)this._value, (float)this._min, (float)this._max);
            this.updateLabel();
        }

        public void setStep(float standard, float large) {
            this._step = standard;
            this._largeStep = large;
        }

        public void setStep(float step) {
            this._step = this._largeStep = step;
        }

        public float getStandardStep() {
            return this._step;
        }

        public float getLargeStep() {
            return this._largeStep;
        }

        @Override
        protected void increment(BooleanSupplier useLargeStep, BooleanSupplier toMax) {
            if (toMax.getAsBoolean()) {
                this._value = this._max;
            } else {
                float step = useLargeStep.getAsBoolean() ? this._largeStep : this._step;
                float v = this.getAsFloat();
                this._value = v <= this._max - step ? v + step : this._max;
            }
        }

        @Override
        protected void decrement(BooleanSupplier useLargeStep, BooleanSupplier toMin) {
            if (toMin.getAsBoolean()) {
                this._value = this._min;
            } else {
                float step = useLargeStep.getAsBoolean() ? this._largeStep : this._step;
                float v = this.getAsFloat();
                this._value = v >= this._min + step ? v - step : this._min;
            }
        }

        @Override
        protected String getAsString() {
            return Float.toString(this.getAsFloat());
        }

        public Float get() {
            return Float.valueOf(this._value);
        }

        public float getAsFloat() {
            return this._value;
        }
    }

    public static class LongNumberInput
    extends NumberInput<Long> {
        private long _value;
        private long _step;
        private long _largeStep;
        private long _min;
        private long _max;

        public LongNumberInput(ModContainerScreen<? extends ModContainer> gui, String name, long value) {
            this(gui, name, Long.MIN_VALUE, Long.MAX_VALUE, value);
        }

        public LongNumberInput(ModContainerScreen<? extends ModContainer> gui, String name, long min, long max, long value) {
            super(gui, name);
            this._min = min;
            this._max = max;
            this.setValue(value);
        }

        public void setValue(long value) {
            this._value = Mth.m_14053_((long)value, (long)this._min, (long)this._max);
            this.updateLabel();
        }

        public void setMinValue(long min) {
            this._min = min;
            this._value = Mth.m_14053_((long)this._value, (long)this._min, (long)this._max);
            this.updateLabel();
        }

        public void setMaxValue(long max) {
            this._max = max;
            this._value = Mth.m_14053_((long)this._value, (long)this._min, (long)this._max);
            this.updateLabel();
        }

        public void setStep(long standard, long large) {
            this._step = standard;
            this._largeStep = large;
        }

        public void setStep(long step) {
            this._step = this._largeStep = step;
        }

        public long getStandardStep() {
            return this._step;
        }

        public long getLargeStep() {
            return this._largeStep;
        }

        @Override
        protected void increment(BooleanSupplier useLargeStep, BooleanSupplier toMax) {
            if (toMax.getAsBoolean()) {
                this._value = this._max;
            } else {
                long step = useLargeStep.getAsBoolean() ? this._largeStep : this._step;
                long v = this.getAsLong();
                this._value = v <= this._max - step ? v + step : this._max;
            }
        }

        @Override
        protected void decrement(BooleanSupplier useLargeStep, BooleanSupplier toMin) {
            if (toMin.getAsBoolean()) {
                this._value = this._min;
            } else {
                long step = useLargeStep.getAsBoolean() ? this._largeStep : this._step;
                long v = this.getAsLong();
                this._value = v >= this._min + step ? v - step : this._min;
            }
        }

        @Override
        protected String getAsString() {
            return Long.toString(this.getAsLong());
        }

        public Long get() {
            return this._value;
        }

        public long getAsLong() {
            return this._value;
        }
    }

    public static class IntNumberInput
    extends NumberInput<Integer> {
        private int _value;
        private int _step;
        private int _largeStep;
        private int _min;
        private int _max;

        public IntNumberInput(ModContainerScreen<? extends ModContainer> gui, String name, int value) {
            this(gui, name, Integer.MIN_VALUE, Integer.MAX_VALUE, value);
        }

        public IntNumberInput(ModContainerScreen<? extends ModContainer> gui, String name, int min, int max, int value) {
            super(gui, name);
            this._min = min;
            this._max = max;
            this.setValue(value);
        }

        public void setValue(int value) {
            this._value = Mth.m_14045_((int)value, (int)this._min, (int)this._max);
            this.updateLabel();
        }

        public void setMinValue(int min) {
            this._min = min;
            this._value = Mth.m_14045_((int)this._value, (int)this._min, (int)this._max);
            this.updateLabel();
        }

        public void setMaxValue(int max) {
            this._max = max;
            this._value = Mth.m_14045_((int)this._value, (int)this._min, (int)this._max);
            this.updateLabel();
        }

        public void setStep(int standard, int large) {
            this._step = standard;
            this._largeStep = large;
        }

        public void setStep(int step) {
            this._step = this._largeStep = step;
        }

        public int getStandardStep() {
            return this._step;
        }

        public int getLargeStep() {
            return this._largeStep;
        }

        @Override
        protected void increment(BooleanSupplier useLargeStep, BooleanSupplier toMax) {
            if (toMax.getAsBoolean()) {
                this._value = this._max;
            } else {
                int step = useLargeStep.getAsBoolean() ? this._largeStep : this._step;
                int v = this.getAsInt();
                this._value = v <= this._max - step ? v + step : this._max;
            }
        }

        @Override
        protected void decrement(BooleanSupplier useLargeStep, BooleanSupplier toMin) {
            if (toMin.getAsBoolean()) {
                this._value = this._min;
            } else {
                int step = useLargeStep.getAsBoolean() ? this._largeStep : this._step;
                int v = this.getAsInt();
                this._value = v >= this._min + step ? v - step : this._min;
            }
        }

        @Override
        protected String getAsString() {
            return Long.toString(this.getAsInt());
        }

        public Integer get() {
            return this._value;
        }

        public int getAsInt() {
            return this._value;
        }
    }
}

