/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.data.nbt.INestedSyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.network.AbstractModTileMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;

public class ModSyncableTileMessage
extends AbstractModTileMessage {
    private final CompoundTag _payload;
    private final boolean _nested;

    public static ModSyncableTileMessage create(BlockPos tileEntityPosition, ISyncableEntity entity) {
        return new ModSyncableTileMessage(tileEntityPosition, entity, false);
    }

    public static ModSyncableTileMessage create(BlockPos tileEntityPosition, INestedSyncableEntity entity) {
        return new ModSyncableTileMessage(tileEntityPosition, entity.getNestedSyncableEntity().orElseThrow(() -> new UnsupportedOperationException("Unable to create a sync message for an empty nested syncable entity")), true);
    }

    public ModSyncableTileMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this._nested = buffer.readBoolean();
        this._payload = buffer.m_130260_();
    }

    @Override
    protected void processTileEntityMessage(LogicalSide sourceSide, BlockEntity tileEntity) {
        ISyncableEntity entity = null;
        if (tileEntity instanceof INestedSyncableEntity && this._nested) {
            entity = ((INestedSyncableEntity)tileEntity).getNestedSyncableEntity().orElse(null);
        } else if (tileEntity instanceof ISyncableEntity) {
            entity = (ISyncableEntity)tileEntity;
        }
        if (null != entity) {
            entity.syncDataFrom(this._payload, ISyncableEntity.SyncReason.NetworkUpdate);
        } else {
            Log.LOGGER.error(Log.NETWORK, "No syncable {}entity found while processing a sync message", (Object)(this._nested ? "(nested) " : ""));
        }
    }

    @Override
    public void encodeTo(FriendlyByteBuf buffer) {
        super.encodeTo(buffer);
        buffer.writeBoolean(this._nested);
        buffer.m_130079_(this._payload);
    }

    protected ModSyncableTileMessage(BlockPos tileEntityPosition, ISyncableEntity entity, boolean nested) {
        super(tileEntityPosition);
        this._nested = nested;
        this._payload = new CompoundTag();
        entity.syncDataTo(this._payload, ISyncableEntity.SyncReason.NetworkUpdate);
    }
}

