/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.world.AbstractWorldGenFeaturesMap;
import it.zerono.mods.zerocore.lib.world.OreGenRegisteredFeature;
import it.zerono.mods.zerocore.lib.world.WorldGenManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.commons.lang3.tuple.Pair;

public class WorldReGenHandler
extends AbstractWorldGenFeaturesMap<Holder<Biome>> {
    private static final long MAX_CHUNKS_PROCESS_TIME = 16000000L;
    private final BooleanSupplier _enabled;
    private final String _worldGenVersionTagName;
    private final IntSupplier _worldGenCurrentVersion;
    private Map<ResourceLocation, Queue<ChunkPos>> _chunksToRegen;

    public WorldReGenHandler(String worldGenVersionTagName, IntSupplier worldGenCurrentVersionSupplier, BooleanSupplier enabledCheck) {
        this._enabled = enabledCheck;
        this._worldGenVersionTagName = worldGenVersionTagName;
        this._worldGenCurrentVersion = worldGenCurrentVersionSupplier;
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::onChunkDataSave);
        bus.addListener(this::onChunkDataLoad);
        bus.addListener(this::onServerStopped);
        bus.addListener(this::onWorldTick);
    }

    public static Predicate<Holder<Biome>> matchAll() {
        return biome -> true;
    }

    public static Predicate<Holder<Biome>> matchOnly(ResourceLocation biomeId) {
        return biomeHolder -> biomeHolder.m_203373_(biomeId);
    }

    public static Predicate<Holder<Biome>> anyExcept(ResourceLocation biomeId) {
        return biomeHolder -> !biomeHolder.m_203373_(biomeId);
    }

    public static Predicate<Holder<Biome>> onlyNether() {
        return biomeHolder -> Biome.BiomeCategory.NETHER == Biome.m_204183_((Holder)biomeHolder);
    }

    public static Predicate<Holder<Biome>> exceptNether() {
        return biomeHolder -> Biome.BiomeCategory.NETHER != Biome.m_204183_((Holder)biomeHolder);
    }

    public static Predicate<Holder<Biome>> onlyTheEnd() {
        return biomeHolder -> Biome.BiomeCategory.THEEND == Biome.m_204183_((Holder)biomeHolder);
    }

    public static Predicate<Holder<Biome>> exceptTheEnd() {
        return biomeHolder -> Biome.BiomeCategory.THEEND != Biome.m_204183_((Holder)biomeHolder);
    }

    public static OreGenRegisteredFeature oreVein(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<ModBlock> oreBlock, RuleTest matchRule, int oresPerVein, int veinsPerChunk, int minY, int maxY) {
        return OreGenRegisteredFeature.regeneration(name, idFactory, oreBlock, matchRule, oresPerVein).standardVein(veinsPerChunk, minY, maxY);
    }

    public static OreGenRegisteredFeature oreDeepVein(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<ModBlock> oreBlock, RuleTest matchRule, int oresPerVein, int veinsPerChunk) {
        return OreGenRegisteredFeature.regeneration(name, idFactory, oreBlock, matchRule, oresPerVein).deepVein(veinsPerChunk);
    }

    public static Pair<OreGenRegisteredFeature, OreGenRegisteredFeature> oreVeinWithRegen(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<ModBlock> oreBlock, RuleTest matchRule, int oresPerVein, int veinsPerChunk, int minY, int maxY) {
        return Pair.of((Object)WorldGenManager.oreVein(name, idFactory, oreBlock, matchRule, oresPerVein, veinsPerChunk, minY, maxY), (Object)WorldReGenHandler.oreVein(name, idFactory, oreBlock, matchRule, oresPerVein, veinsPerChunk, minY, maxY));
    }

    public static Pair<OreGenRegisteredFeature, OreGenRegisteredFeature> oreDeepVeinWithRegen(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<ModBlock> oreBlock, RuleTest matchRule, int oresPerVein, int veinsPerChunk) {
        return Pair.of((Object)WorldGenManager.oreDeepVein(name, idFactory, oreBlock, matchRule, oresPerVein, veinsPerChunk), (Object)WorldReGenHandler.oreDeepVein(name, idFactory, oreBlock, matchRule, oresPerVein, veinsPerChunk));
    }

    public void addOreVein(Pair<OreGenRegisteredFeature, OreGenRegisteredFeature> veins, Predicate<BiomeLoadingEvent> genBiomeMatcher, Predicate<Holder<Biome>> reGenBiomeMatcher) {
        WorldGenManager.INSTANCE.addOreVein(genBiomeMatcher, (OreGenRegisteredFeature)veins.getLeft());
        this.addOreVein(reGenBiomeMatcher, (OreGenRegisteredFeature)veins.getRight());
    }

    private boolean enabled() {
        return this._enabled.getAsBoolean();
    }

    private String getWorldGenVersionTagName() {
        return "zcwg_" + this._worldGenVersionTagName;
    }

    private synchronized void onChunkDataLoad(ChunkDataEvent.Load event) {
        LevelAccessor world = event.getWorld();
        if (this.enabled() && world instanceof Level && !world.m_5776_() && (!event.getData().m_128441_(this.getWorldGenVersionTagName()) || event.getData().m_128451_(this.getWorldGenVersionTagName()) < this._worldGenCurrentVersion.getAsInt())) {
            this.addChunkToRegen((ResourceKey<Level>)((Level)world).m_46472_(), event.getChunk().m_7697_());
        }
    }

    private void onChunkDataSave(ChunkDataEvent.Save event) {
        if (this.enabled() && null != event.getWorld() && !event.getWorld().m_5776_()) {
            event.getData().m_128405_(this.getWorldGenVersionTagName(), this._worldGenCurrentVersion.getAsInt());
        }
    }

    private void onServerStopped(ServerStoppedEvent event) {
        if (null != this._chunksToRegen) {
            this._chunksToRegen.clear();
        }
    }

    private void onWorldTick(TickEvent.WorldTickEvent event) {
        if (this.enabled() && event.side.isServer() && TickEvent.Phase.END == event.phase) {
            this.processChunks((ServerLevel)event.world);
        }
    }

    private void addChunkToRegen(ResourceKey<Level> dimension, ChunkPos chunkPosition) {
        Queue positions;
        if (null == this._chunksToRegen) {
            this._chunksToRegen = new Object2ObjectArrayMap();
        }
        if (!(positions = this._chunksToRegen.computeIfAbsent(dimension.m_135782_(), k -> new LinkedList())).contains(chunkPosition)) {
            positions.add(chunkPosition);
        }
    }

    private void processChunks(ServerLevel world) {
        ResourceLocation dimensionId;
        if (!world.f_46443_ && null != this._chunksToRegen && this._chunksToRegen.containsKey(dimensionId = world.m_46472_().m_135782_())) {
            ChunkPos nextChunk;
            Queue<ChunkPos> chunksToGen = this._chunksToRegen.get(dimensionId);
            long startTime = System.nanoTime();
            while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && null != (nextChunk = chunksToGen.poll())) {
                Random random = new Random(world.m_7328_());
                long xSeed = random.nextLong() >> 3;
                long zSeed = random.nextLong() >> 3;
                random.setSeed(xSeed * (long)nextChunk.f_45578_ + zSeed * (long)nextChunk.f_45579_ ^ world.m_7328_());
                this.regenerateChunk(world, random, nextChunk.f_45578_, nextChunk.f_45579_);
            }
            if (chunksToGen.isEmpty()) {
                this._chunksToRegen.remove(dimensionId);
            }
        }
    }

    private void regenerateChunk(ServerLevel world, Random random, int chunkX, int chunkZ) {
        if (!world.m_7232_(chunkX, chunkZ)) {
            return;
        }
        ChunkGenerator chunkGenerator = world.m_7726_().m_8481_();
        BlockPos position = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        Holder biome = world.m_204166_(position);
        for (GenerationStep.Decoration stage : this._entries.keySet()) {
            boolean processed = false;
            for (Pair pair : (List)this._entries.get(stage)) {
                if (!((Predicate)pair.getKey()).test(biome)) continue;
                processed |= ((PlacedFeature)((Holder)((Supplier)pair.getValue()).get()).m_203334_()).m_191782_((WorldGenLevel)world, chunkGenerator, random, position);
            }
            if (!processed) continue;
            Log.LOGGER.info(Log.CORE, "Retro-gen run on chunk {}, {}", (Object)chunkX, (Object)chunkZ);
        }
    }
}

