/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.VirtualSlotContainerScreen;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.GuiVirtualSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiWarningTab;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.IGUIWindow;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.IVirtualSlot;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.IWarningTracker;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.collection.LRU;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public abstract class GuiMekanism<CONTAINER extends AbstractContainerMenu>
extends VirtualSlotContainerScreen<CONTAINER>
implements IGuiWrapper,
IFancyFontRenderer {
    public static final ResourceLocation BASE_BACKGROUND = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "base.png");
    public static final ResourceLocation SHADOW = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "shadow.png");
    public static final ResourceLocation BLUR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "blur.png");
    protected boolean dynamicSlots;
    protected final LRU<GuiWindow> windows = new LRU();
    protected final List<GuiElement> focusListeners = new ArrayList<GuiElement>();
    public boolean switchingToJEI;
    @Nullable
    private IWarningTracker warningTracker;
    private boolean hasClicked = false;
    public static int maxZOffset;
    private int maxZOffsetNoWindows;

    protected GuiMekanism(CONTAINER container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    @Nonnull
    public BooleanSupplier trackWarning(@Nonnull WarningTracker.WarningType type, @Nonnull BooleanSupplier warningSupplier) {
        if (this.warningTracker == null) {
            this.warningTracker = new WarningTracker();
        }
        return this.warningTracker.trackWarning(type, warningSupplier);
    }

    public void m_7861_() {
        if (!this.switchingToJEI) {
            this.windows.forEach(GuiWindow::close);
            super.m_7861_();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.warningTracker != null) {
            this.warningTracker.clearTrackedWarnings();
        }
        this.addGuiElements();
        if (this.warningTracker != null) {
            this.addWarningTab(this.warningTracker);
        }
    }

    protected void addWarningTab(IWarningTracker warningTracker) {
        this.addRenderableWidget(new GuiWarningTab(this, warningTracker, 109));
    }

    protected void addGuiElements() {
        if (this.dynamicSlots) {
            this.addSlots();
        }
    }

    protected <T extends GuiElement> T addElement(T element) {
        this.f_169369_.add(element);
        this.m_6702_().add(element);
        return element;
    }

    protected <T extends GuiElement> T addRenderableWidget(T element) {
        return this.addElement(element);
    }

    public void m_181908_() {
        super.m_181908_();
        this.m_6702_().stream().filter(child -> child instanceof GuiElement).map(child -> (GuiElement)child).forEach(GuiElement::tick);
        this.windows.forEach(GuiElement::tick);
    }

    protected void renderTitleText(PoseStack poseStack) {
        this.drawTitleText(poseStack, this.f_96539_, this.f_97729_);
    }

    protected GuiElement.IHoverable getOnHover(ILangEntry translationHelper) {
        return this.getOnHover(() -> translationHelper.translate(new Object[0]));
    }

    protected GuiElement.IHoverable getOnHover(Supplier<Component> componentSupplier) {
        return (onHover, matrix, mouseX, mouseY) -> this.displayTooltips(matrix, mouseX, mouseY, new Component[]{(Component)componentSupplier.get()});
    }

    protected ResourceLocation getButtonLocation(String name) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, name + ".png");
    }

    @Override
    public void addFocusListener(GuiElement element) {
        this.focusListeners.add(element);
    }

    @Override
    public void removeFocusListener(GuiElement element) {
        this.focusListeners.remove(element);
    }

    @Override
    public void focusChange(GuiElement changed) {
        this.focusListeners.stream().filter(e -> e != changed).forEach(e -> e.m_93692_(false));
    }

    @Override
    public void incrementFocus(GuiElement current) {
        int index = this.focusListeners.indexOf(current);
        if (index != -1) {
            GuiElement next = this.focusListeners.get((index + 1) % this.focusListeners.size());
            next.m_93692_(true);
            this.focusChange(next);
        }
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return this.getWindowHovering(mouseX, mouseY) == null && super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    public void m_6575_(@Nonnull Minecraft minecraft, int width, int height) {
        this.switchingToJEI = false;
        record PreviousElement(int index, GuiElement element) {
        }
        ArrayList<PreviousElement> prevElements = new ArrayList<PreviousElement>();
        for (int i = 0; i < this.m_6702_().size(); ++i) {
            GuiElement element2;
            GuiEventListener widget = (GuiEventListener)this.m_6702_().get(i);
            if (!(widget instanceof GuiElement) || !(element2 = (GuiElement)widget).hasPersistentData()) continue;
            prevElements.add(new PreviousElement(i, element2));
        }
        this.focusListeners.removeIf(element -> !element.isOverlay);
        int prevLeft = this.f_97735_;
        int prevTop = this.f_97736_;
        super.m_6575_(minecraft, width, height);
        this.windows.forEach(window -> window.resize(prevLeft, prevTop, this.f_97735_, this.f_97736_));
        prevElements.forEach(e -> {
            GuiEventListener widget;
            if (e.index() < this.m_6702_().size() && (widget = (GuiEventListener)this.m_6702_().get(e.index())).getClass() == e.element().getClass()) {
                ((GuiElement)widget).syncFrom(e.element());
            }
        });
    }

    protected void m_7027_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        int zOffset;
        PoseStack modelViewStack = RenderSystem.m_157191_();
        matrix.m_85837_(0.0, 0.0, 300.0);
        modelViewStack.m_85837_((double)(-this.f_97735_), (double)(-this.f_97736_), 0.0);
        RenderSystem.m_157182_();
        this.m_6702_().stream().filter(c -> c instanceof GuiElement).forEach(c -> ((GuiElement)c).onDrawBackground(matrix, mouseX, mouseY, MekanismRenderer.getPartialTick()));
        modelViewStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        RenderSystem.m_157182_();
        this.drawForegroundText(matrix, mouseX, mouseY);
        this.maxZOffsetNoWindows = maxZOffset = (zOffset = 200);
        for (GuiEventListener widget : this.m_6702_()) {
            if (!(widget instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)widget;
            matrix.m_85836_();
            element.onRenderForeground(matrix, mouseX, mouseY, zOffset, zOffset);
            matrix.m_85849_();
        }
        this.maxZOffsetNoWindows = maxZOffset;
        int windowSeparation = 150;
        LRU.LRUIterator iter = this.getWindowsDescendingIterator();
        while (iter.hasNext()) {
            GuiWindow overlay = (GuiWindow)iter.next();
            zOffset = maxZOffset + windowSeparation;
            matrix.m_85836_();
            overlay.onRenderForeground(matrix, mouseX, mouseY, zOffset, zOffset);
            if (iter.hasNext()) {
                overlay.renderBlur(matrix);
            }
            matrix.m_85849_();
        }
        GuiElement tooltipElement = this.getWindowHovering(mouseX, mouseY);
        if (tooltipElement == null) {
            for (int i = this.m_6702_().size() - 1; i >= 0; --i) {
                GuiElement element;
                GuiEventListener widget = (GuiEventListener)this.m_6702_().get(i);
                if (!(widget instanceof GuiElement) || !(element = (GuiElement)widget).m_5953_(mouseX, mouseY)) continue;
                tooltipElement = element;
                break;
            }
        }
        modelViewStack.m_85837_(0.0, 0.0, (double)maxZOffset);
        modelViewStack.m_85837_((double)(-this.f_97735_), (double)(-this.f_97736_), 0.0);
        RenderSystem.m_157182_();
        if (tooltipElement != null) {
            tooltipElement.m_7428_(matrix, mouseX, mouseY);
        }
        this.m_7025_(matrix, mouseX, mouseY);
        modelViewStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        modelViewStack.m_85837_(0.0, 0.0, 200.0);
        RenderSystem.m_157182_();
        this.maxZOffsetNoWindows = -(maxZOffset - windowSeparation * this.windows.size());
    }

    protected void drawForegroundText(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
    }

    @Nonnull
    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        GuiWindow window = this.getWindowHovering(mouseX, mouseY);
        return window == null ? super.m_94729_(mouseX, mouseY) : Optional.of(window);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.hasClicked = true;
        GuiWindow top = this.windows.isEmpty() ? null : (GuiWindow)this.windows.iterator().next();
        GuiWindow focused = this.windows.stream().filter(overlay -> overlay.m_6375_(mouseX, mouseY, button)).findFirst().orElse(null);
        if (focused != null) {
            if (this.windows.contains(focused)) {
                this.m_7522_((GuiEventListener)focused);
                if (button == 0) {
                    this.m_7897_(true);
                }
                if (top != focused) {
                    top.onFocusLost();
                    this.windows.moveUp(focused);
                    focused.onFocused();
                }
            }
            return true;
        }
        for (int i = this.m_6702_().size() - 1; i >= 0; --i) {
            GuiEventListener listener = (GuiEventListener)this.m_6702_().get(i);
            if (!listener.m_6375_(mouseX, mouseY, button)) continue;
            this.m_7522_(listener);
            if (button == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.hasClicked) {
            this.windows.forEach(w -> w.m_7691_(mouseX, mouseY));
            return super.m_6348_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.windows.stream().anyMatch(window -> window.m_7933_(keyCode, scanCode, modifiers)) || GuiUtils.checkChildren(this.m_6702_(), child -> child.m_7933_(keyCode, scanCode, modifiers)) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char c, int keyCode) {
        return this.windows.stream().anyMatch(window -> window.m_5534_(c, keyCode)) || GuiUtils.checkChildren(this.m_6702_(), child -> child.m_5534_(c, keyCode)) || super.m_5534_(c, keyCode);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseXOld, double mouseYOld) {
        super.m_7979_(mouseX, mouseY, button, mouseXOld, mouseYOld);
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, mouseXOld, mouseYOld);
    }

    @Override
    @Nullable
    @Deprecated
    protected Slot m_97744_(double mouseX, double mouseY) {
        boolean checkedWindow = false;
        boolean overNoButtons = false;
        GuiWindow window = null;
        for (Slot slot : this.f_97732_.f_38839_) {
            if (!slot.m_6659_()) continue;
            boolean virtual = slot instanceof IVirtualSlot;
            int xPos = slot.f_40220_;
            int yPos = slot.f_40221_;
            if (virtual) {
                IVirtualSlot virtualSlot = (IVirtualSlot)slot;
                if (!this.isVirtualSlotAvailable(virtualSlot)) continue;
                xPos = virtualSlot.getActualX();
                yPos = virtualSlot.getActualY();
            }
            if (!super.m_6774_(xPos, yPos, 16, 16, mouseX, mouseY)) continue;
            if (!checkedWindow) {
                checkedWindow = true;
                window = this.getWindowHovering(mouseX, mouseY);
                overNoButtons = this.overNoButtons(window, mouseX, mouseY);
            }
            if (!overNoButtons || !slot.m_6659_()) continue;
            if (window == null) {
                return slot;
            }
            if (!virtual || !window.childrenContainsElement(element -> {
                GuiVirtualSlot v;
                return element instanceof GuiVirtualSlot && (v = (GuiVirtualSlot)element).isElementForSlot((IVirtualSlot)slot);
            })) continue;
            return slot;
        }
        return null;
    }

    @Override
    protected boolean isMouseOverSlot(@Nonnull Slot slot, double mouseX, double mouseY) {
        if (slot instanceof IVirtualSlot) {
            GuiWindow window;
            int yPos;
            int xPos;
            IVirtualSlot virtualSlot = (IVirtualSlot)slot;
            if (this.isVirtualSlotAvailable(virtualSlot) && super.m_6774_(xPos = virtualSlot.getActualX(), yPos = virtualSlot.getActualY(), 16, 16, mouseX, mouseY) && ((window = this.getWindowHovering(mouseX, mouseY)) == null || window.childrenContainsElement(element -> {
                GuiVirtualSlot v;
                return element instanceof GuiVirtualSlot && (v = (GuiVirtualSlot)element).isElementForSlot(virtualSlot);
            }))) {
                return this.overNoButtons(window, mouseX, mouseY);
            }
            return false;
        }
        return this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY);
    }

    private boolean overNoButtons(@Nullable GuiWindow window, double mouseX, double mouseY) {
        if (window == null) {
            return this.m_6702_().stream().noneMatch(button -> button.m_5953_(mouseX, mouseY));
        }
        return !window.childrenContainsElement(e -> e.m_5953_(mouseX, mouseY));
    }

    private boolean isVirtualSlotAvailable(IVirtualSlot virtualSlot) {
        GuiWindow linkedWindow;
        IGUIWindow iGUIWindow = virtualSlot.getLinkedWindow();
        return !(iGUIWindow instanceof GuiWindow) || this.windows.contains(linkedWindow = (GuiWindow)iGUIWindow);
    }

    protected boolean m_6774_(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.m_6774_(x, y, width, height, mouseX, mouseY) && this.getWindowHovering(mouseX, mouseY) == null && this.overNoButtons(null, mouseX, mouseY);
    }

    protected void addSlots() {
        int size = this.f_97732_.f_38839_.size();
        for (int i = 0; i < size; ++i) {
            Slot slot = (Slot)this.f_97732_.f_38839_.get(i);
            if (slot instanceof InventoryContainerSlot) {
                SlotType type;
                InventoryContainerSlot containerSlot = (InventoryContainerSlot)slot;
                ContainerSlotType slotType = containerSlot.getSlotType();
                DataType dataType = this.findDataType(containerSlot);
                if (dataType != null) {
                    type = SlotType.get(dataType);
                } else if (slotType == ContainerSlotType.INPUT || slotType == ContainerSlotType.OUTPUT || slotType == ContainerSlotType.EXTRA) {
                    type = SlotType.NORMAL;
                } else if (slotType == ContainerSlotType.POWER) {
                    type = SlotType.POWER;
                } else {
                    if (slotType != ContainerSlotType.NORMAL && slotType != ContainerSlotType.VALIDITY) continue;
                    type = SlotType.NORMAL;
                }
                GuiSlot guiSlot = new GuiSlot(type, this, slot.f_40220_ - 1, slot.f_40221_ - 1);
                containerSlot.addWarnings(guiSlot);
                SlotOverlay slotOverlay = containerSlot.getSlotOverlay();
                if (slotOverlay != null) {
                    guiSlot.with(slotOverlay);
                }
                if (slotType == ContainerSlotType.VALIDITY) {
                    int index = i;
                    guiSlot.validity(() -> this.checkValidity(index));
                }
                this.addRenderableWidget(guiSlot);
                continue;
            }
            this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, slot.f_40220_ - 1, slot.f_40221_ - 1));
        }
    }

    @Nullable
    protected DataType findDataType(InventoryContainerSlot slot) {
        MekanismTileContainer container;
        Object object = this.f_97732_;
        if (object instanceof MekanismTileContainer && (object = (container = (MekanismTileContainer)object).getTileEntity()) instanceof ISideConfiguration) {
            ISideConfiguration sideConfig = (ISideConfiguration)object;
            return sideConfig.getActiveDataType(slot.getInventorySlot());
        }
        return null;
    }

    protected ItemStack checkValidity(int slotIndex) {
        return ItemStack.f_41583_;
    }

    protected void m_7286_(@Nonnull PoseStack matrix, float partialTick, int mouseX, int mouseY) {
        MekanismRenderer.resetColor();
        if (this.f_96543_ < 8 || this.f_96544_ < 8) {
            Mekanism.logger.warn("Gui: {}, was too small to draw the background of. Unable to draw a background for a gui smaller than 8 by 8.", (Object)this.getClass().getSimpleName());
            return;
        }
        GuiUtils.renderBackgroundTexture(matrix, BASE_BACKGROUND, 4, 4, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, 256, 256);
    }

    @Override
    public Font getFont() {
        return this.f_96547_;
    }

    public void m_6305_(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_(0.0, 0.0, -500.0);
        RenderSystem.m_157182_();
        matrix.m_85836_();
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        matrix.m_85849_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public void m_169388_(@Nonnull PoseStack poseStack, @Nonnull List<Component> tooltips, @Nonnull Optional<TooltipComponent> visualTooltipComponent, int mouseX, int mouseY) {
        this.adjustTooltipZ(poseStack, pose -> super.m_169388_(pose, tooltips, visualTooltipComponent, mouseX, mouseY));
    }

    public void m_96597_(@Nonnull PoseStack poseStack, @Nonnull List<Component> tooltips, int mouseX, int mouseY) {
        this.adjustTooltipZ(poseStack, pose -> super.m_96597_(pose, tooltips, mouseX, mouseY));
    }

    public void renderComponentTooltip(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedText> tooltips, int mouseX, int mouseY, @Nullable Font font, @Nonnull ItemStack stack) {
        this.adjustTooltipZ(poseStack, pose -> super.renderComponentTooltip(pose, tooltips, mouseX, mouseY, font, stack));
    }

    public void m_96617_(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedCharSequence> tooltips, int mouseX, int mouseY) {
        this.adjustTooltipZ(poseStack, pose -> super.m_96617_(pose, tooltips, mouseX, mouseY));
    }

    private void adjustTooltipZ(@Nonnull PoseStack poseStack, @Nonnull Consumer<PoseStack> tooltipRender) {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_(0.0, 0.0, (double)(-this.maxZOffsetNoWindows - 1));
        modelViewStack.m_166854_(poseStack.m_85850_().m_85861_());
        RenderSystem.m_157182_();
        tooltipRender.accept(new PoseStack());
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    @Override
    public void renderItemTooltip(PoseStack matrix, @Nonnull ItemStack stack, int xAxis, int yAxis) {
        this.m_6057_(matrix, stack, xAxis, yAxis);
    }

    @Override
    public void renderItemTooltipWithExtra(PoseStack matrix, @Nonnull ItemStack stack, int xAxis, int yAxis, List<Component> toAppend) {
        if (toAppend.isEmpty()) {
            this.renderItemTooltip(matrix, stack, xAxis, yAxis);
        } else {
            ArrayList<Component> tooltip = new ArrayList<Component>(this.m_96555_(stack));
            tooltip.addAll(toAppend);
            this.renderTooltip(matrix, tooltip, stack.m_150921_(), xAxis, yAxis, stack);
        }
    }

    @Override
    public ItemRenderer getItemRenderer() {
        return this.f_96542_;
    }

    @Override
    public boolean currentlyQuickCrafting() {
        return this.f_97738_ && !this.f_97737_.isEmpty();
    }

    @Override
    public void addWindow(GuiWindow window) {
        GuiWindow top;
        GuiWindow guiWindow = top = this.windows.isEmpty() ? null : (GuiWindow)this.windows.iterator().next();
        if (top != null) {
            top.onFocusLost();
        }
        this.windows.add(window);
        window.onFocused();
    }

    @Override
    public void removeWindow(GuiWindow window) {
        if (!this.windows.isEmpty()) {
            GuiWindow top = (GuiWindow)this.windows.iterator().next();
            this.windows.remove(window);
            if (window == top) {
                GuiWindow newTop;
                window.onFocusLost();
                GuiWindow guiWindow = newTop = this.windows.isEmpty() ? null : (GuiWindow)this.windows.iterator().next();
                if (newTop == null) {
                    this.lastWindowRemoved();
                } else {
                    newTop.onFocused();
                }
                this.m_7522_((GuiEventListener)newTop);
            }
        }
    }

    protected void lastWindowRemoved() {
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof MekanismContainer) {
            MekanismContainer container = (MekanismContainer)abstractContainerMenu;
            container.setSelectedWindow(null);
        }
    }

    @Override
    public void setSelectedWindow(SelectedWindowData selectedWindow) {
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof MekanismContainer) {
            MekanismContainer container = (MekanismContainer)abstractContainerMenu;
            container.setSelectedWindow(selectedWindow);
        }
    }

    @Override
    @Nullable
    public GuiWindow getWindowHovering(double mouseX, double mouseY) {
        return this.windows.stream().filter(w -> w.m_5953_(mouseX, mouseY)).findFirst().orElse(null);
    }

    public Collection<GuiWindow> getWindows() {
        return this.windows;
    }

    public LRU.LRUIterator getWindowsDescendingIterator() {
        return this.windows.descendingIterator();
    }
}

