/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.client.model.ModelJetpack;
import mekanism.client.model.ModelPartData;
import mekanism.common.Mekanism;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;

public class ModelArmoredJetpack
extends ModelJetpack {
    public static final ModelLayerLocation ARMORED_JETPACK_LAYER = new ModelLayerLocation(Mekanism.rl("armored_jetpack"), "main");
    private static final ModelPartData THRUSTER_LEFT = ModelArmoredJetpack.thrusterLeft(-1.9f);
    private static final ModelPartData THRUSTER_RIGHT = ModelArmoredJetpack.thrusterRight(-1.9f);
    private static final ModelPartData FUEL_TUBE_RIGHT = ModelArmoredJetpack.fuelTubeRight(-1.9f);
    private static final ModelPartData FUEL_TUBE_LEFT = ModelArmoredJetpack.fuelTubeLeft(-1.9f);
    private static final ModelPartData CHESTPLATE = new ModelPartData("chestplate", CubeListBuilder.m_171558_().m_171514_(104, 22).m_171481_(-4.0f, 1.333333f, -3.0f, 8.0f, 4.0f, 3.0f), PartPose.m_171430_((float)-0.3665191f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData LEFT_GUARD_TOP = new ModelPartData("leftGuardTop", CubeListBuilder.m_171558_().m_171514_(87, 31).m_171481_(0.95f, 3.0f, -5.0f, 3.0f, 4.0f, 2.0f), PartPose.m_171430_((float)0.2094395f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData RIGHT_GUARD_TOP = new ModelPartData("rightGuardTop", CubeListBuilder.m_171558_().m_171514_(87, 31).m_171481_(-3.95f, 3.0f, -5.0f, 3.0f, 4.0f, 2.0f), PartPose.m_171430_((float)0.2094395f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData MIDDLE_PLATE = new ModelPartData("middlePlate", CubeListBuilder.m_171558_().m_171514_(93, 20).m_171481_(-1.5f, 3.0f, -6.2f, 3.0f, 5.0f, 3.0f), PartPose.m_171430_((float)0.2094395f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData RIGHT_GUARD_BOT = new ModelPartData("rightGuardBot", CubeListBuilder.m_171558_().m_171514_(84, 30).m_171481_(-3.5f, 5.5f, -6.5f, 2.0f, 2.0f, 2.0f), PartPose.m_171430_((float)0.4712389f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData LEFT_GUARD_BOT = new ModelPartData("leftGuardBot", CubeListBuilder.m_171558_().m_171514_(84, 30).m_171481_(1.5f, 5.5f, -6.5f, 2.0f, 2.0f, 2.0f), PartPose.m_171430_((float)0.4712389f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData RIGHT_LIGHT = new ModelPartData("rightLight", CubeListBuilder.m_171558_().m_171514_(81, 0).m_171481_(-3.0f, 4.0f, -4.5f, 1.0f, 3.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData LEFT_LIGHT = new ModelPartData("leftLight", CubeListBuilder.m_171558_().m_171514_(81, 0).m_171481_(2.0f, 4.0f, -4.5f, 1.0f, 3.0f, 1.0f), new ModelPartData[0]);
    private final List<ModelPart> armoredParts;
    private final List<ModelPart> armoredLights;

    public static LayerDefinition createLayerDefinition() {
        return ModelArmoredJetpack.createLayerDefinition(128, 64, PACK_TOP, PACK_BOTTOM, THRUSTER_LEFT, THRUSTER_RIGHT, FUEL_TUBE_RIGHT, FUEL_TUBE_LEFT, PACK_MID, PACK_CORE, WING_SUPPORT_L, WING_SUPPORT_R, PACK_TOP_REAR, EXTENDO_SUPPORT_L, EXTENDO_SUPPORT_R, WING_BLADE_L, WING_BLADE_R, PACK_DOODAD_2, PACK_DOODAD_3, BOTTOM_THRUSTER, LIGHT_1, LIGHT_2, LIGHT_3, CHESTPLATE, LEFT_GUARD_TOP, RIGHT_GUARD_TOP, MIDDLE_PLATE, RIGHT_GUARD_BOT, LEFT_GUARD_BOT, RIGHT_LIGHT, LEFT_LIGHT);
    }

    public ModelArmoredJetpack(EntityModelSet entityModelSet) {
        this(entityModelSet.m_171103_(ARMORED_JETPACK_LAYER));
    }

    private ModelArmoredJetpack(ModelPart root) {
        super(root);
        this.armoredParts = ModelArmoredJetpack.getRenderableParts(root, CHESTPLATE, LEFT_GUARD_TOP, RIGHT_GUARD_TOP, MIDDLE_PLATE, RIGHT_GUARD_BOT, LEFT_GUARD_BOT);
        this.armoredLights = ModelArmoredJetpack.getRenderableParts(root, RIGHT_LIGHT, LEFT_LIGHT);
    }

    @Override
    public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int light, int overlayLight, float red, float green, float blue, float alpha) {
        super.m_7695_(poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, -0.0625);
        ModelArmoredJetpack.renderPartsToBuffer(this.armoredParts, poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha);
        ModelArmoredJetpack.renderPartsToBuffer(this.armoredLights, poseStack, vertexConsumer, 0xF000F0, overlayLight, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

