/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.client.render.obj.TransmitterModelConfiguration;
import mekanism.client.render.obj.TransmitterModelTransform;
import mekanism.client.render.obj.VisibleModelConfiguration;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.obj.OBJModel;

public class TransmitterBakedModel
implements BakedModel {
    private final OBJModel internal;
    @Nullable
    private final OBJModel glass;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final ItemOverrides overrides;
    private final ResourceLocation modelLocation;
    private final BakedModel bakedVariant;
    private final Map<QuickHash, List<BakedQuad>> modelCache;

    public TransmitterBakedModel(OBJModel internal, @Nullable OBJModel glass, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        this.modelCache = new Object2ObjectOpenHashMap(glass == null ? 4096 : 8192);
        this.internal = internal;
        this.glass = glass;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.overrides = overrides;
        this.modelLocation = modelLocation;
        List<String> visible = Arrays.stream(EnumUtils.DIRECTIONS).map(side -> side.m_122433_() + (side.m_122434_() == Direction.Axis.Y ? "NORMAL" : "NONE")).toList();
        this.bakedVariant = internal.bake((IModelConfiguration)new VisibleModelConfiguration(owner, visible), bakery, spriteGetter, modelTransform, overrides, modelLocation);
    }

    @Nonnull
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null) {
            return Collections.emptyList();
        }
        if (extraData.hasProperty(TileEntityTransmitter.TRANSMITTER_PROPERTY)) {
            TransmitterModelData data = (TransmitterModelData)extraData.getData(TileEntityTransmitter.TRANSMITTER_PROPERTY);
            RenderType layer = MinecraftForgeClient.getRenderType();
            boolean hasColor = data.getHasColor() && layer == RenderType.m_110466_();
            QuickHash hash = new QuickHash(data.getConnectionsMap(), hasColor);
            if (!this.modelCache.containsKey(hash)) {
                ArrayList<String> visible = new ArrayList<String>();
                for (Direction dir : EnumUtils.DIRECTIONS) {
                    visible.add(dir.m_7912_() + data.getConnectionType(dir).m_7912_().toUpperCase(Locale.ROOT));
                }
                List result = this.bake(new TransmitterModelConfiguration(this.owner, visible, extraData), hasColor).getQuads(state, null, rand, extraData);
                this.modelCache.put(hash, result);
                return result;
            }
            return this.modelCache.get(hash);
        }
        return this.bakedVariant.getQuads(state, null, rand, extraData);
    }

    private BakedModel bake(TransmitterModelConfiguration configuration, boolean hasColor) {
        TextureAtlasSprite particle = this.spriteGetter.apply(configuration.resolveTexture("particle"));
        IModelBuilder builder = IModelBuilder.of((IModelConfiguration)configuration, (ItemOverrides)this.overrides, (TextureAtlasSprite)particle);
        this.addPartQuads(configuration, builder, this.internal);
        if (this.glass != null && hasColor && MinecraftForgeClient.getRenderType() == RenderType.m_110466_()) {
            this.addPartQuads(configuration, builder, this.glass);
        }
        return builder.build();
    }

    private void addPartQuads(TransmitterModelConfiguration configuration, IModelBuilder<?> builder, OBJModel glass) {
        for (IModelGeometryPart part : glass.getParts()) {
            if (!configuration.getPartVisibility(part)) continue;
            String name = part.name();
            ModelState transform = this.modelTransform;
            if (name.endsWith("NONE")) {
                Direction dir = TransmitterBakedModel.directionForPiece(name);
                TransmitterModelConfiguration.IconStatus status = configuration.getIconStatus(dir);
                if (dir != null && status.getAngle() > 0.0f) {
                    transform = new TransmitterModelTransform(transform, dir, status.getAngle());
                }
            }
            part.addQuads((IModelConfiguration)configuration, builder, this.bakery, this.spriteGetter, transform, this.modelLocation);
        }
    }

    @Nullable
    private static Direction directionForPiece(@Nonnull String piece) {
        return Arrays.stream(EnumUtils.DIRECTIONS).filter(dir -> piece.startsWith(dir.m_122433_())).findFirst().orElse(null);
    }

    public boolean m_7541_() {
        return this.bakedVariant.m_7541_();
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return this.bakedVariant.useAmbientOcclusion(state);
    }

    public boolean m_7539_() {
        return this.bakedVariant.m_7539_();
    }

    public boolean m_7547_() {
        return this.bakedVariant.m_7547_();
    }

    public boolean m_7521_() {
        return this.bakedVariant.m_7521_();
    }

    @Nonnull
    @Deprecated
    public TextureAtlasSprite m_6160_() {
        return this.bakedVariant.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.bakedVariant.getParticleIcon(data);
    }

    public boolean doesHandlePerspectives() {
        return this.bakedVariant.doesHandlePerspectives();
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        return this.bakedVariant.handlePerspective(cameraTransformType, mat);
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.bakedVariant.m_7343_();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return this.bakedVariant.getModelData(world, pos, state, tileData);
    }

    @Nonnull
    @Deprecated
    public ItemTransforms m_7442_() {
        return this.bakedVariant.m_7442_();
    }

    public record QuickHash(Object[] objs) {
        @Override
        public int hashCode() {
            return Arrays.hashCode(this.objs);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof QuickHash)) return false;
            QuickHash other = (QuickHash)obj;
            if (!Arrays.deepEquals(this.objs, other.objs)) return false;
            return true;
        }
    }
}

