/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.ChemicalOxidizerIRecipe;
import mekanism.common.recipe.impl.GasConversionIRecipe;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToGas")
public abstract class ItemStackToGasRecipeManager
extends MekanismRecipeManager<ItemStackToGasRecipe> {
    protected ItemStackToGasRecipeManager(IMekanismRecipeTypeProvider<ItemStackToGasRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, ICrTChemicalStack.ICrTGasStack output) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, this.getAndValidateNotEmpty(output)));
    }

    protected abstract ItemStackToGasRecipe makeRecipe(ResourceLocation var1, ItemStackIngredient var2, GasStack var3);

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(ItemStackToGasRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                return CrTUtils.describeOutputs(((ItemStackToGasRecipe)this.recipe).getOutputDefinition(), CrTChemicalStack.CrTGasStack::new);
            }
        };
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToGas.Oxidizing")
    public static class ChemicalOxidizerRecipeManager
    extends ItemStackToGasRecipeManager {
        public static final ChemicalOxidizerRecipeManager INSTANCE = new ChemicalOxidizerRecipeManager();

        private ChemicalOxidizerRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToGasRecipe, ?>)MekanismRecipeType.OXIDIZING);
        }

        @Override
        protected ItemStackToGasRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, GasStack output) {
            return new ChemicalOxidizerIRecipe(id, input, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToGas.GasConversion")
    public static class GasConversionRecipeManager
    extends ItemStackToGasRecipeManager {
        public static final GasConversionRecipeManager INSTANCE = new GasConversionRecipeManager();

        private GasConversionRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToGasRecipe, ?>)MekanismRecipeType.GAS_CONVERSION);
        }

        @Override
        protected ItemStackToGasRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, GasStack output) {
            return new GasConversionIRecipe(id, input, output);
        }
    }
}

