/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.util.StackUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class HashedItem {
    @Nonnull
    private final ItemStack itemStack;
    private final int hashCode;

    public static HashedItem create(@Nonnull ItemStack stack) {
        return new HashedItem(StackUtils.size(stack, 1));
    }

    public static HashedItem raw(@Nonnull ItemStack stack) {
        return new HashedItem(stack);
    }

    protected HashedItem(@Nonnull ItemStack stack) {
        this.itemStack = stack;
        this.hashCode = this.initHashCode();
    }

    protected HashedItem(HashedItem other) {
        this.itemStack = other.itemStack;
        this.hashCode = other.hashCode;
    }

    @Nonnull
    public ItemStack getStack() {
        return this.itemStack;
    }

    @Nonnull
    public ItemStack createStack(int size) {
        return StackUtils.size(this.itemStack, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HashedItem)) return false;
        HashedItem other = (HashedItem)obj;
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.itemStack, (ItemStack)other.itemStack)) return false;
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int initHashCode() {
        int code = 1;
        code = 31 * code + this.itemStack.m_41720_().hashCode();
        if (this.itemStack.m_41782_()) {
            code = 31 * code + this.itemStack.m_41783_().hashCode();
        }
        return code;
    }

    public static class UUIDAwareHashedItem
    extends HashedItem {
        private final UUID uuid;
        private final boolean overrideHash;

        public UUIDAwareHashedItem(ItemStack stack, UUID uuid) {
            super(StackUtils.size(stack, 1));
            this.uuid = uuid;
            this.overrideHash = true;
        }

        public UUIDAwareHashedItem(HashedItem other, UUID uuid) {
            super(other);
            this.uuid = uuid;
            this.overrideHash = false;
        }

        @Nullable
        public UUID getUUID() {
            return this.uuid;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.overrideHash) return super.equals(obj);
            if (this.uuid == null) return super.equals(obj);
            if (!(obj instanceof UUIDAwareHashedItem)) return false;
            UUIDAwareHashedItem uuidAware = (UUIDAwareHashedItem)obj;
            if (!this.uuid.equals(uuidAware.uuid)) return false;
            if (!super.equals(obj)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            if (this.overrideHash && this.uuid != null) {
                return 31 * super.hashCode() + this.uuid.hashCode();
            }
            return super.hashCode();
        }

        public HashedItem asRawHashedItem() {
            return new HashedItem(this);
        }
    }
}

