/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.bin;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.bin.BinRecipe;
import mekanism.common.registries.MekanismRecipeSerializers;
import mekanism.common.util.MekanismUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BinExtractRecipe
extends BinRecipe {
    public BinExtractRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ItemStack binStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_41720_() instanceof ItemBlockBin) {
                if (!binStack.m_41619_()) {
                    return false;
                }
                binStack = stackInSlot;
                continue;
            }
            return false;
        }
        if (binStack.m_41619_()) {
            return false;
        }
        return !BinExtractRecipe.convertToSlot(binStack).isEmpty();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack binStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_41720_() instanceof ItemBlockBin) {
                if (!binStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                binStack = stackInSlot;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (binStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return BinExtractRecipe.convertToSlot(binStack).getBottomStack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (!(stackInSlot.m_41720_() instanceof ItemBlockBin)) continue;
            ItemStack binStack = stackInSlot.m_41777_();
            BinInventorySlot slot = BinExtractRecipe.convertToSlot(binStack);
            ItemStack bottomStack = slot.getBottomStack();
            if (bottomStack.m_41619_()) break;
            MekanismUtils.logMismatchedStackSize(slot.shrinkStack(bottomStack.m_41613_(), Action.EXECUTE), bottomStack.m_41613_());
            remaining.set(i, (Object)binStack);
            break;
        }
        return remaining;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MekanismRecipeSerializers.BIN_EXTRACT.get();
    }
}

