/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonObject;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.recipe.WrappedShapedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WrappedShapedRecipeSerializer<RECIPE extends WrappedShapedRecipe>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final Function<ShapedRecipe, RECIPE> wrapper;

    public WrappedShapedRecipeSerializer(Function<ShapedRecipe, RECIPE> wrapper) {
        this.wrapper = wrapper;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        return (RECIPE)((WrappedShapedRecipe)this.wrapper.apply((ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json)));
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            return (RECIPE)((WrappedShapedRecipe)this.wrapper.apply((ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer)));
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading wrapped shaped recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        try {
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)((WrappedShapedRecipe)recipe).getInternal());
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing wrapped shaped recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

