/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.tier.BinTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.upgrade.BinUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityBin
extends TileEntityMekanism
implements IConfigurable {
    public int addTicks = 0;
    public int removeTicks = 0;
    private int delayTicks;
    private BinTier tier;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getStored"})
    private BinInventorySlot binSlot;

    public TileEntityBin(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.tier = Attribute.getTier(this.getBlockType(), BinTier.class);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.binSlot = BinInventorySlot.create(listener, this.tier);
        builder.addSlot(this.binSlot);
        return builder.build();
    }

    public BinTier getTier() {
        return this.tier;
    }

    public int getItemCount() {
        return this.binSlot.getCount();
    }

    public BinInventorySlot getBinSlot() {
        return this.binSlot;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.addTicks = Math.max(0, this.addTicks - 1);
        this.removeTicks = Math.max(0, this.removeTicks - 1);
        this.delayTicks = Math.max(0, this.delayTicks - 1);
        if (this.delayTicks == 0) {
            if (this.getActive()) {
                TransitRequest.TransitResponse response;
                BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), this.m_58899_().m_7495_());
                TileTransitRequest request = new TileTransitRequest(this, Direction.DOWN);
                request.addItem(this.binSlot.getBottomStack(), 0);
                if (tile instanceof TileEntityLogisticalTransporterBase) {
                    TileEntityLogisticalTransporterBase transporter = (TileEntityLogisticalTransporterBase)tile;
                    response = transporter.getTransmitter().insert((BlockEntity)this, (TransitRequest)request, null, true, 0);
                } else {
                    response = request.addToInventory(tile, Direction.DOWN, 0, false);
                }
                if (!response.isEmpty() && this.tier != BinTier.CREATIVE) {
                    int sendingAmount = response.getSendingAmount();
                    MekanismUtils.logMismatchedStackSize(this.binSlot.shrinkStack(sendingAmount, Action.EXECUTE), sendingAmount);
                }
                this.delayTicks = 10;
            }
        } else {
            --this.delayTicks;
        }
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        this.setActive(!this.getActive());
        Level world = this.m_58904_();
        if (world != null) {
            world.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_12490_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof BinUpgradeData) {
            BinUpgradeData data = (BinUpgradeData)upgradeData;
            this.redstone = data.redstone();
            this.binSlot.setStack(data.binSlot().getStack());
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public BinUpgradeData getUpgradeData() {
        return new BinUpgradeData(this.redstone, this.getBinSlot());
    }

    @Override
    public void onContentsChanged() {
        super.onContentsChanged();
        if (this.f_58857_ != null && !this.isRemote()) {
            this.sendUpdatePacket();
        }
    }

    @Override
    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128365_("Item", (Tag)this.binSlot.serializeNBT());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setCompoundIfPresent(tag, "Item", nbt -> this.binSlot.deserializeNBT((CompoundTag)nbt));
    }

    @ComputerMethod
    private int getCapacity() {
        return this.binSlot.getLimit(this.binSlot.getStack());
    }
}

