/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityQIORedstoneAdapter
extends TileEntityQIOComponent
implements ISustainedData {
    public static final ModelProperty<Boolean> POWERING_PROPERTY = new ModelProperty();
    private boolean prevPowering;
    private HashedItem itemType = null;
    private long count = 0L;
    private long clientStoredCount = 0L;

    public TileEntityQIORedstoneAdapter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.QIO_REDSTONE_ADAPTER, pos, state);
    }

    public boolean isPowering() {
        if (this.isRemote()) {
            return this.prevPowering;
        }
        QIOFrequency freq = this.getQIOFrequency();
        if (freq != null && this.itemType != null) {
            long stored = freq.getStored(this.itemType);
            return stored > 0L && stored >= this.count;
        }
        return false;
    }

    public void handleStackChange(ItemStack stack) {
        this.itemType = stack.m_41619_() ? null : HashedItem.create(stack);
        this.markForSave();
    }

    public void handleCountChange(long count) {
        if (this.count != count) {
            this.count = count;
            this.markForSave();
        }
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        boolean powering = this.isPowering();
        if (powering != this.prevPowering) {
            Level world = this.m_58904_();
            if (world != null) {
                world.m_46672_(this.m_58899_(), this.getBlockType());
            }
            this.prevPowering = powering;
            this.sendUpdatePacket();
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(POWERING_PROPERTY, (Object)this.prevPowering).build();
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        if (this.itemType != null) {
            dataMap.m_128365_("singleItem", (Tag)this.itemType.getStack().m_41739_(new CompoundTag()));
        }
        dataMap.m_128356_("amount", this.count);
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        NBTUtils.setItemStackIfPresent(dataMap, "singleItem", item -> {
            this.itemType = HashedItem.create(item);
        });
        NBTUtils.setLongIfPresent(dataMap, "amount", value -> {
            this.count = value;
        });
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("singleItem", "singleItem");
        remap.put("amount", "amount");
        return remap;
    }

    @Override
    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128379_("active", this.prevPowering);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.prevPowering = tag.m_128471_("active");
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.m_58904_(), this.m_58899_(), this.m_58900_());
    }

    @ComputerMethod(nameOverride="getTargetItem")
    public ItemStack getItemType() {
        return this.itemType == null ? ItemStack.f_41583_ : this.itemType.getStack();
    }

    @ComputerMethod(nameOverride="getTriggerAmount")
    public long getCount() {
        return this.count;
    }

    public long getStoredCount() {
        return this.clientStoredCount;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableItemStack.create(this::getItemType, value -> {
            this.itemType = value.m_41619_() ? null : HashedItem.create(value);
        }));
        container.track(SyncableLong.create(this::getCount, value -> {
            this.count = value;
        }));
        container.track(SyncableLong.create(() -> {
            QIOFrequency freq = this.getQIOFrequency();
            return freq != null && this.itemType != null ? freq.getStored(this.itemType) : 0L;
        }, value -> {
            this.clientStoredCount = value;
        }));
    }

    @ComputerMethod
    private void clearTargetItem() throws ComputerException {
        this.validateSecurityIsPublic();
        this.handleStackChange(ItemStack.f_41583_);
    }

    @ComputerMethod
    private void setTargetItem(ResourceLocation itemName) throws ComputerException {
        this.validateSecurityIsPublic();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemName);
        if (item == null || item == Items.f_41852_) {
            throw new ComputerException("Target item '%s' could not be found. If you are trying to clear it consider using clearTargetItem instead.", itemName);
        }
        this.handleStackChange(new ItemStack((ItemLike)item));
    }

    @ComputerMethod
    private void setTriggerAmount(long amount) throws ComputerException {
        this.validateSecurityIsPublic();
        if (amount < 0L) {
            throw new ComputerException("Trigger amount cannot be negative. Received: %d", amount);
        }
        this.handleCountChange(amount);
    }
}

