/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import com.mojang.serialization.Codec;
import mekanism.common.world.ResizableDiskConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ResizableDiskReplaceFeature
extends Feature<ResizableDiskConfig> {
    public ResizableDiskReplaceFeature(Codec<ResizableDiskConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ResizableDiskConfig> context) {
        boolean placed = false;
        BlockPos pos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        if (world.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            ResizableDiskConfig config = (ResizableDiskConfig)context.m_159778_();
            int halfHeight = config.halfHeight.getAsInt();
            int yMax = pos.m_123342_() + halfHeight;
            int yMin = pos.m_123342_() - halfHeight - 1;
            int radius = config.radius.m_142270_(context.m_159776_());
            int radiusSquared = radius * radius;
            for (int x = pos.m_123341_() - radius; x <= pos.m_123341_() + radius; ++x) {
                int xRadius = x - pos.m_123341_();
                int xRadiusSquared = xRadius * xRadius;
                for (int z = pos.m_123343_() - radius; z <= pos.m_123343_() + radius; ++z) {
                    int zRadius = z - pos.m_123343_();
                    if (xRadiusSquared + zRadius * zRadius > radiusSquared) continue;
                    block2: for (int y = yMax; y > yMin; --y) {
                        BlockPos targetPos = new BlockPos(x, y, z);
                        Block blockAtTarget = world.m_8055_(targetPos).m_60734_();
                        for (BlockState target : config.targets) {
                            if (!target.m_60713_(blockAtTarget)) continue;
                            world.m_7731_(targetPos, config.state, 2);
                            this.m_159739_(world, targetPos);
                            placed = true;
                            continue block2;
                        }
                    }
                }
            }
        }
        return placed;
    }
}

