/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class TimeFavoriteEntry
extends FavoriteEntry {
    public static final class_2960 ID = new class_2960("roughlyenoughitems", "time");
    public static final String TRANSLATION_KEY = "favorite.section.time";
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    public static final String KEY = "mode";
    @Nullable
    private final Time time;

    public TimeFavoriteEntry(@Nullable Time time) {
        this.time = time;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public Renderer getRenderer(boolean showcase) {
        if (this.time == null) {
            List renderers = IntStream.range(0, 4).mapToObj(TimeFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(showcase, renderers, () -> this.nextTime().ordinal()){

                @Override
                @Nullable
                public Tooltip getTooltip(Point mouse) {
                    return Tooltip.create(mouse, new class_2561[]{new class_2588("text.rei.time_button.tooltip.dropdown")});
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    return this.hashCode() == o.hashCode();
                }

                public int hashCode() {
                    return Objects.hash(this.getClass(), this.showcase);
                }
            };
        }
        return TimeFavoriteEntry.getRenderer(this.time.ordinal());
    }

    private Time nextTime() {
        class_638 level = class_310.method_1551().field_1687;
        long dayTime = level.method_8532();
        if (dayTime <= 1000L) {
            return Time.MORN;
        }
        if (dayTime <= 6000L) {
            return Time.NOON;
        }
        if (dayTime <= 12000L) {
            return Time.EVENING;
        }
        if (dayTime <= 18000L) {
            return Time.NIGHT;
        }
        return Time.MORN;
    }

    private static Renderer getRenderer(int id) {
        final Time time = Time.values()[id];
        return new AbstractRenderer(){

            @Override
            public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color;
                int n = color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                if (bounds.width > 4 && bounds.height > 4) {
                    matrices.method_22903();
                    matrices.method_22904((double)bounds.getCenterX(), (double)bounds.getCenterY(), 0.0);
                    matrices.method_22905((float)bounds.getWidth() / 18.0f, (float)bounds.getHeight() / 18.0f, 1.0f);
                    this.renderTimeIcon(matrices, time, 0, 0, color);
                    matrices.method_22909();
                }
            }

            private void renderTimeIcon(class_4587 matrices, Time time2, int centerX, int centerY, int color) {
                RenderSystem.setShaderTexture((int)0, (class_2960)CHEST_GUI_TEXTURE);
                2.method_25290((class_4587)matrices, (int)(centerX - 7), (int)(centerY - 7), (float)(time2.ordinal() * 14 + 42), (float)14.0f, (int)14, (int)14, (int)256, (int)256);
            }

            @Override
            @Nullable
            public Tooltip getTooltip(Point mouse) {
                return Tooltip.create(mouse, new class_2561[]{new class_2588("text.rei.time_button.tooltip.entry", new Object[]{new class_2588("text.rei.time_button.name." + time.name().toLowerCase(Locale.ROOT))})});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.getClass(), false, time});
            }
        };
    }

    @Override
    public boolean doAction(int button) {
        if (button == 0) {
            Time time = this.time;
            if (time == null) {
                time = this.nextTime();
            }
            class_310.method_1551().field_1724.method_3142(ConfigObject.getInstance().getTimeCommand().replaceAll("\\{time}", time.getPart().toLowerCase(Locale.ROOT)));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return false;
    }

    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (this.time == null) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.map(Time.values(), TimeMenuEntry::new);
    }

    @Override
    public long hashIgnoreAmount() {
        return this.time == null ? 31290831290L : (long)this.time.ordinal();
    }

    @Override
    public FavoriteEntry copy() {
        return this;
    }

    @Override
    public class_2960 getType() {
        return ID;
    }

    @Override
    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof TimeFavoriteEntry)) {
            return false;
        }
        TimeFavoriteEntry that = (TimeFavoriteEntry)other;
        return Objects.equals((Object)this.time, (Object)that.time);
    }

    public static enum Time {
        MORN("1000"),
        NOON("6000"),
        EVENING("12000"),
        NIGHT("18000");

        String part;

        private Time(String part) {
            this.part = part;
        }

        public String getPart() {
            return this.part;
        }
    }

    public static class TimeMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final Time time;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public TimeMenuEntry(Time time) {
            this.text = class_1074.method_4662((String)("text.rei.time_button.name." + time.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
            this.time = time;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.method_1727(this.text));
            }
            return this.textWidth;
        }

        @Override
        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        @Override
        public int getEntryHeight() {
            return 12;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        @Override
        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.selected) {
                TimeMenuEntry.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)-12237499);
            }
            if (this.selected && this.containsMouse) {
                REIRuntime.getInstance().queueTooltip(Tooltip.create(new class_2561[]{new class_2588("text.rei.time_button.tooltip.entry", new Object[]{this.text})}));
            }
            this.font.method_1729(matrices, this.text, (float)(this.x + 2), (float)(this.y + 2), this.selected ? 0xFFFFFF : 0x888888);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12)) {
                class_310.method_1551().field_1724.method_3142(ConfigObject.getInstance().getTimeCommand().replaceAll("\\{time}", this.time.getPart().toLowerCase(Locale.ROOT)));
                this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                this.closeMenu();
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    public static enum Type implements FavoriteEntryType<TimeFavoriteEntry>
    {
        INSTANCE;


        @Override
        public DataResult<TimeFavoriteEntry> read(class_2487 object) {
            String stringValue = object.method_10558(TimeFavoriteEntry.KEY);
            Time type = stringValue.equals("NOT_SET") ? null : Time.valueOf(stringValue);
            return DataResult.success((Object)new TimeFavoriteEntry(type), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public DataResult<TimeFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error((String)"Cannot create GameModeFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof Time)) {
                return DataResult.error((String)"Creation of GameModeFavoriteEntry from args expected Time as the first argument!");
            }
            Time type = (Time)((Object)object);
            return DataResult.success((Object)new TimeFavoriteEntry(type), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public class_2487 save(TimeFavoriteEntry entry, class_2487 tag) {
            tag.method_10582(TimeFavoriteEntry.KEY, entry.time == null ? "NOT_SET" : entry.time.name());
            return tag;
        }
    }
}

