/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class DefaultInformationDisplay
implements Display {
    private EntryIngredient entryStacks;
    private List<class_2561> texts;
    private class_2561 name;

    protected DefaultInformationDisplay(EntryIngredient entryStacks, class_2561 name) {
        this.entryStacks = entryStacks;
        this.name = name;
        this.texts = Lists.newArrayList();
    }

    public static DefaultInformationDisplay createFromEntries(EntryIngredient entryStacks, class_2561 name) {
        return new DefaultInformationDisplay(entryStacks, name);
    }

    public static DefaultInformationDisplay createFromEntry(EntryStack<?> entryStack, class_2561 name) {
        return DefaultInformationDisplay.createFromEntries(EntryIngredient.of(entryStack), name);
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return Collections.singletonList(this.entryStacks);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(this.entryStacks);
    }

    public DefaultInformationDisplay line(class_2561 line) {
        this.texts.add(line);
        return this;
    }

    public DefaultInformationDisplay lines(class_2561 ... lines) {
        this.texts.addAll(Arrays.asList(lines));
        return this;
    }

    public DefaultInformationDisplay lines(Collection<class_2561> lines) {
        this.texts.addAll(lines);
        return this;
    }

    public EntryIngredient getEntryStacks() {
        return this.entryStacks;
    }

    public class_2561 getName() {
        return this.name;
    }

    public List<class_2561> getTexts() {
        return this.texts;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.INFO;
    }

    public static DisplaySerializer<DefaultInformationDisplay> serializer() {
        return new DisplaySerializer<DefaultInformationDisplay>(){

            @Override
            public class_2487 save(class_2487 tag, DefaultInformationDisplay display) {
                tag.method_10566("stacks", (class_2520)display.getEntryStacks().saveIngredient());
                tag.method_10582("name", class_2561.class_2562.method_10867((class_2561)display.getName()));
                class_2499 descriptions = new class_2499();
                for (class_2561 text : display.getTexts()) {
                    descriptions.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text)));
                }
                tag.method_10566("descriptions", (class_2520)descriptions);
                return tag;
            }

            @Override
            public DefaultInformationDisplay read(class_2487 tag) {
                EntryIngredient stacks = EntryIngredient.read(tag.method_10554("stacks", 10));
                class_5250 name = class_2561.class_2562.method_10877((String)tag.method_10558("name"));
                ArrayList<class_2561> descriptions = new ArrayList<class_2561>();
                for (class_2520 descriptionTag : tag.method_10554("descriptions", 8)) {
                    descriptions.add((class_2561)class_2561.class_2562.method_10877((String)descriptionTag.method_10714()));
                }
                return new DefaultInformationDisplay(stacks, (class_2561)name).lines(descriptions);
            }
        };
    }
}

