var Opcodes=Java.type('org.objectweb.asm.Opcodes')
var InsnList=Java.type('org.objectweb.asm.tree.InsnList')
var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
var MethodNode=Java.type('org.objectweb.asm.tree.MethodNode')
var InsnNode=Java.type('org.objectweb.asm.tree.InsnNode')
var FieldInsnNode=Java.type('org.objectweb.asm.tree.FieldInsnNode')
var LabelNode=Java.type('org.objectweb.asm.tree.LabelNode')
var LocalVariableNode=Java.type('org.objectweb.asm.tree.LocalVariableNode')
var Label=Java.type('org.objectweb.asm.Label')
var JumpInsnNode=Java.type('org.objectweb.asm.tree.JumpInsnNode')
var FieldNode=Java.type('org.objectweb.asm.tree.FieldNode')

function clientPacketRedirectTransformCustomPatch(methodNode, patchList){
	var instructions = methodNode.instructions
	for(var i = 0; i < instructions.size(); i++) {
		var insn = instructions.get(i);
		if(insn.getOpcode() == Opcodes.INVOKESTATIC) {
			if(insn.owner.equals("net/minecraft/network/protocol/PacketUtils") && (insn.name.equals("ensureRunningOnSameThread") || insn.name.equals("m_131363_"))) {
				instructions.insert(insn, patchList);
				break;
			}
		}
	}
}

function clientPacketRedirectTransformCustom(methodNode, methodInsnNode, localVariable){
	var patchList = new InsnList()
	patchList.add(new VarInsnNode(Opcodes.ALOAD, localVariable))
	//INVOKESTATIC xaero/common/core/LaunchPlugin.chunkUpdateCallback (Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$ChunkRender;)V
	patchList.add(methodInsnNode)
	clientPacketRedirectTransformCustomPatch(methodNode, patchList)
}

function clientPacketRedirectTransformCustomDouble(methodNode, methodInsnNode, localVariable, localVariable2){
	var patchList = new InsnList()
	patchList.add(new VarInsnNode(Opcodes.ALOAD, localVariable))
	patchList.add(new VarInsnNode(Opcodes.ALOAD, localVariable2))
	patchList.add(methodInsnNode)
	clientPacketRedirectTransformCustomPatch(methodNode, patchList)
}

function clientPacketRedirectTransform(methodNode, methodInsnNode){
	clientPacketRedirectTransformCustom(methodNode, methodInsnNode, 1)
}

function addCustomGetter(classNode, fieldName, fieldDesc, methodName){
	var methods = classNode.methods
	var getterNode = new MethodNode(Opcodes.ACC_PUBLIC, methodName, "()" + fieldDesc, null, null)
	var labelNode1 = new LabelNode()
	var labelNode2 = new LabelNode()
	var instructions = getterNode.instructions
	instructions.add(labelNode1)
	instructions.add(new VarInsnNode(Opcodes.ALOAD, 0))
	instructions.add(new FieldInsnNode(Opcodes.GETFIELD, classNode.name, fieldName, fieldDesc))
	instructions.add(new InsnNode(Opcodes.ARETURN))
	instructions.add(labelNode2)
	getterNode.localVariables.add(new LocalVariableNode("this", "L" + classNode.name + ";", null, labelNode1, labelNode2, 0))
	getterNode.maxStack = 1
	getterNode.maxLocals = 1
	methods.add(getterNode)
}

function addGetter(classNode, fieldName, fieldDesc){
	addCustomGetter(classNode, fieldName, fieldDesc, "get" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1))
}

function addSetter(classNode, fieldName, fieldDesc){
	var methods = classNode.methods
	var setterNode = new MethodNode(Opcodes.ACC_PUBLIC, "set" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1), "(" + fieldDesc +  ")V", null, null)
	var labelNode1 = new LabelNode()
	var labelNode2 = new LabelNode()
	var instructions = setterNode.instructions
	instructions.add(labelNode1)
	instructions.add(new VarInsnNode(Opcodes.ALOAD, 0))
	instructions.add(new VarInsnNode(Opcodes.ALOAD, 1))
	instructions.add(new FieldInsnNode(Opcodes.PUTFIELD, classNode.name, fieldName, fieldDesc))
	instructions.add(new InsnNode(Opcodes.RETURN))
	instructions.add(labelNode2)
	setterNode.localVariables.add(new LocalVariableNode("this", "L" + classNode.name + ";", null, labelNode1, labelNode2, 0))
	setterNode.localVariables.add(new LocalVariableNode("value", fieldDesc, null, labelNode1, labelNode2, 1))
	setterNode.maxStack = 2
	setterNode.maxLocals = 2
	methods.add(setterNode)
}

function initializeCoreMod() {
	return {
		'xaero_wm_chunkclass': {
			'target' : {
				'type' : 'CLASS',
				'name' : 'net.minecraft.world.level.chunk.LevelChunk'
			},
			'transformer' : function(classNode){
				var fields = classNode.fields
				fields.add(new FieldNode(Opcodes.ACC_PUBLIC, "xaero_wm_chunkClean", "Z", null, 0))
				return classNode
			}
		},
		'xaero_wm_clientplaynethandler_handleblockchange': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.multiplayer.ClientPacketListener',
                'methodName': 'm_6773_',
                'methodDesc' : '(Lnet/minecraft/network/protocol/game/ClientboundBlockUpdatePacket;)V'
			},
			'transformer' : function(methodNode){
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/core/XaeroWorldMapCore', 
						"onBlockChange", "(Lnet/minecraft/network/protocol/game/ClientboundBlockUpdatePacket;)V"))
				return methodNode
			}
		},
		'xaero_wm_clientplaynethandler_handlemultiblockchange': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.multiplayer.ClientPacketListener',
                'methodName': 'm_5771_',
                'methodDesc' : '(Lnet/minecraft/network/protocol/game/ClientboundSectionBlocksUpdatePacket;)V'
			},
			'transformer' : function(methodNode){
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/core/XaeroWorldMapCore', 
						"onMultiBlockChange", "(Lnet/minecraft/network/protocol/game/ClientboundSectionBlocksUpdatePacket;)V"))
				return methodNode
			}
		},
		'xaero_wm_clientplaynethandler_updatelevelchunk': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.multiplayer.ClientPacketListener',
                'methodName': 'm_194198_',
                'methodDesc' : '(IILnet/minecraft/network/protocol/game/ClientboundLevelChunkPacketData;)V'
			},
			'transformer' : function(methodNode){
				var patchList = new InsnList();
				patchList.add(new VarInsnNode(Opcodes.ILOAD, 1))
				patchList.add(new VarInsnNode(Opcodes.ILOAD, 2))
				patchList.add(new VarInsnNode(Opcodes.ALOAD, 3))
				patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/core/XaeroWorldMapCore', 
						"onChunkData", "(IILnet/minecraft/network/protocol/game/ClientboundLevelChunkPacketData;)V"))
				methodNode.instructions.insert(methodNode.instructions.get(0), patchList)
				return methodNode
			}
		},
		'xaero_wm_clientplaynethandler_queuelightupdate': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.multiplayer.ClientPacketListener',
                'methodName': 'm_194202_',
                'methodDesc' : '(IILnet/minecraft/network/protocol/game/ClientboundLightUpdatePacketData;)V'
			},
			'transformer' : function(methodNode){
				var patchList = new InsnList();
				patchList.add(new VarInsnNode(Opcodes.ILOAD, 1))
				patchList.add(new VarInsnNode(Opcodes.ILOAD, 2))
				patchList.add(new VarInsnNode(Opcodes.ALOAD, 3))
				patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/core/XaeroWorldMapCore', 
						"onChunkLightData", "(IILnet/minecraft/network/protocol/game/ClientboundLightUpdatePacketData;)V"))
				methodNode.instructions.insert(methodNode.instructions.get(0), patchList)
				return methodNode
			}
		},
		'xaero_clientplaynethandler_handlespawnpoint': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.multiplayer.ClientPacketListener',
                'methodName': 'm_6571_',
                'methodDesc' : '(Lnet/minecraft/network/protocol/game/ClientboundSetDefaultSpawnPositionPacket;)V'
			},
			'transformer' : function(methodNode){
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/core/XaeroWorldMapCore', 
						"onSpawn", "(Lnet/minecraft/network/protocol/game/ClientboundSetDefaultSpawnPositionPacket;)V"))
				return methodNode
			}
		},
		'xaero_wm_abstractclientplayerentity_getlocationcape': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.player.AbstractClientPlayer',
                'methodName': 'm_108561_',
                'methodDesc' : '()Lnet/minecraft/resources/ResourceLocation;'
			},
			'transformer' : function(methodNode){
				var MY_LABEL = new LabelNode(new Label())
				methodNode.maxStack += 1
				var insnToInsert = new InsnList()
				insnToInsert.add(new VarInsnNode(Opcodes.ALOAD, 0))
				insnToInsert.add(new MethodInsnNode(Opcodes.INVOKESTATIC, "xaero/map/core/XaeroWorldMapCore", "getPlayerCape", "(Lnet/minecraft/client/player/AbstractClientPlayer;)Lnet/minecraft/resources/ResourceLocation;"))
				insnToInsert.add(new InsnNode(Opcodes.DUP))
				insnToInsert.add(new JumpInsnNode(Opcodes.IFNULL, MY_LABEL))
				insnToInsert.add(new InsnNode(Opcodes.ARETURN))
				insnToInsert.add(MY_LABEL)
				insnToInsert.add(new InsnNode(Opcodes.POP))
				methodNode.instructions.insert(methodNode.instructions.get(0), insnToInsert)
				return methodNode
			}
		},
		'xaero_wm_playerentity_iswearing': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.world.entity.player.Player',
                'methodName': 'm_36170_',
                'methodDesc' : '(Lnet/minecraft/world/entity/player/PlayerModelPart;)Z'
			},
			'transformer' : function(methodNode){
				var MY_LABEL = new LabelNode(new Label())
				var insnToInsert = new InsnList()
				insnToInsert.add(new VarInsnNode(Opcodes.ALOAD, 0))
				insnToInsert.add(new VarInsnNode(Opcodes.ALOAD, 1))
				insnToInsert.add(new MethodInsnNode(Opcodes.INVOKESTATIC, "xaero/map/core/XaeroWorldMapCore", "isWearing", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/player/PlayerModelPart;)Ljava/lang/Boolean;"))
				insnToInsert.add(new InsnNode(Opcodes.DUP))
				insnToInsert.add(new JumpInsnNode(Opcodes.IFNULL, MY_LABEL))
				insnToInsert.add(new MethodInsnNode(Opcodes.INVOKEVIRTUAL, "java/lang/Boolean", "booleanValue", "()Z"))
				insnToInsert.add(new InsnNode(Opcodes.IRETURN))
				insnToInsert.add(MY_LABEL)
				insnToInsert.add(new InsnNode(Opcodes.POP))
				methodNode.instructions.insert(methodNode.instructions.get(0), insnToInsert)
				return methodNode
			}
		},
		'xaero_wm_clientplaynethandlerclass': {
			'target' : {
				'type' : 'CLASS',
				'name' : 'net.minecraft.client.multiplayer.ClientPacketListener'
			},
			'transformer' : function(classNode){
				var fields = classNode.fields
				
				classNode.interfaces.add("xaero/map/core/IWorldMapClientPlayNetHandler")
				fields.add(new FieldNode(Opcodes.ACC_PRIVATE, "xaero_worldmapSession", "Lxaero/map/WorldMapSession;", null, null))
				addGetter(classNode, "xaero_worldmapSession", "Lxaero/map/WorldMapSession;")
				addSetter(classNode, "xaero_worldmapSession", "Lxaero/map/WorldMapSession;")
				
				return classNode
			}
		},
		'xaero_wm_clientplaynethandler_handlejoingame': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.multiplayer.ClientPacketListener',
                'methodName': 'm_5998_',
                'methodDesc' : '(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V'
			},
			'transformer' : function(methodNode){
				clientPacketRedirectTransformCustomDouble(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/core/XaeroWorldMapCore', "onPlayNetHandler", "(Lnet/minecraft/client/multiplayer/ClientPacketListener;Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"), 0, 1)
				return methodNode
			}
		},
		'xaero_wm_clientplaynethandler_cleanup': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.multiplayer.ClientPacketListener',
                'methodName': 'm_105140_',
                'methodDesc' : '()V'
			},
			'transformer' : function(methodNode){
				var instructions = methodNode.instructions
				var patchList = new InsnList()
				patchList.add(new VarInsnNode(Opcodes.ALOAD, 0))
				patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/core/XaeroWorldMapCore', 
						"onPlayNetHandlerCleanup", "(Lnet/minecraft/client/multiplayer/ClientPacketListener;)V"))
				instructions.insert(instructions.get(0), patchList)
				return methodNode
			}
		},
		'xaero_wm_clientworldclass': {
			'target' : {
				'type' : 'CLASS',
				'name' : 'net.minecraft.client.multiplayer.ClientLevel'
			},
			'transformer' : function(classNode){
				var fields = classNode.fields
				
				classNode.interfaces.add("xaero/map/mcworld/IWorldMapClientWorld")
				fields.add(new FieldNode(Opcodes.ACC_PRIVATE, "xaero_worldmapData", "Lxaero/map/mcworld/WorldMapClientWorldData;", null, null))
				addGetter(classNode, "xaero_worldmapData", "Lxaero/map/mcworld/WorldMapClientWorldData;")
				addSetter(classNode, "xaero_worldmapData", "Lxaero/map/mcworld/WorldMapClientWorldData;")
				
				return classNode
			}
		},
		'xaero_wm_smultiblockchangepacketclass': {//1.16.2 and newer
			'target' : {
				'type' : 'CLASS',
				'name' : 'net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket'
			},
			'transformer' : function(classNode){
				
				classNode.interfaces.add("xaero/map/core/IWorldMapSMultiBlockChangePacket")
				var obfName = "f_132980_";
				var normalName = "sectionPos";
				for(var i = 0; i < classNode.fields.size(); i++){
					var f = classNode.fields.get(i)
					if(f.name.equals(obfName) || f.name.equals(normalName)){
						addCustomGetter(classNode, f.name, "Lnet/minecraft/core/SectionPos;", "xaero_wm_getSectionPos")
						break
					}
				}
				return classNode
			}
		},
		'xaero_wm_playerlist_sendworldinfo': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.server.players.PlayerList',
                'methodName': 'm_11229_',
                'methodDesc' : '(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerLevel;)V'
			},
			'transformer' : function(methodNode){
				var instructions = methodNode.instructions
				var patchList = new InsnList()
				patchList.add(new VarInsnNode(Opcodes.ALOAD, 1))
				patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/server/core/XaeroWorldMapServerCore', 
						"onServerWorldInfo", "(Lnet/minecraft/world/entity/player/Player;)V"))
				instructions.insert(instructions.get(0), patchList)
				return methodNode
			}
		},
		'xaero_wm_cyclebutton': {
			'target' : {
				'type' : 'CLASS',
				'name' : 'net.minecraft.client.gui.components.CycleButton'
			},
			'transformer' : function(classNode){
				var fields = classNode.fields
				classNode.interfaces.add("xaero/map/gui/IXaeroClickableWidget")
				fields.add(new FieldNode(Opcodes.ACC_PRIVATE, "xaero_wm_tooltip", "Ljava/util/function/Supplier;", null, null))
				addGetter(classNode, "xaero_wm_tooltip", "Ljava/util/function/Supplier;")
				addSetter(classNode, "xaero_wm_tooltip", "Ljava/util/function/Supplier;")
				
				return classNode
			}
		},
		'xaero_wm_levelstorageaccess_deletelevel': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.world.level.storage.LevelStorageSource$LevelStorageAccess',
                'methodName': 'm_78311_',
				'methodDesc' : '()V',
			},
			'transformer' : function(methodNode){
				var instructions = methodNode.instructions
				var patchList = new InsnList()
				patchList.add(new VarInsnNode(Opcodes.ALOAD, 0))
				patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/core/XaeroWorldMapCore', 
						"onDeleteWorld", "(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;)V"))
				for(var i = instructions.size() - 1; i >= 0; i--){
					if(instructions.get(i).getOpcode() == Opcodes.RETURN){
						instructions.insertBefore(instructions.get(i), patchList)
						break
					}
				}
				return methodNode
			}
		},
		'xaero_wm_minecraft_runtick': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.Minecraft',
                'methodName': 'm_91383_',
				'methodDesc' : '(Z)V',
			},
			'transformer' : function(methodNode){
				var instructions = methodNode.instructions
				var patchList = new InsnList()
				patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/map/core/XaeroWorldMapCore',
						"onMinecraftRunTick", "()V"))
				instructions.insert(instructions.get(0), patchList)
				return methodNode
			}
		}
	}
}