/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class LimitedArrayCacheMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 7161452652266833375L;
    private final int capacity;
    private final ImmutableEntry<K, V>[] entries;
    private int index = 0;

    public LimitedArrayCacheMap(int capacity) {
        this.capacity = capacity;
        this.entries = new ImmutableEntry[capacity];
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        int count = 0;
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (entry == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (entry == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (entry == null || !entry.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (entry == null || !entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public V get(Object key) {
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (entry == null || !entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V ret = this.get(key);
        return ret != null ? ret : defaultValue;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V ret = null;
        if (this.entries[this.index] != null) {
            ret = this.entries[this.index].getValue();
        }
        this.entries[this.index] = new ImmutableEntry(key, value);
        this.removeDuplicates();
        this.index = this.index == this.capacity - 1 ? 0 : this.index + 1;
        return ret;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Immutable data");
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.index = 0;
        for (int i = 0; i < this.capacity; ++i) {
            this.entries[i] = null;
        }
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        LinkedHashSet<K> keySet = new LinkedHashSet<K>();
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (entry == null) continue;
            keySet.add(entry.getKey());
        }
        return keySet;
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        LinkedHashSet<V> valueSet = new LinkedHashSet<V>();
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (entry == null) continue;
            valueSet.add(entry.getValue());
        }
        return valueSet;
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entrySet = new LinkedHashSet<Map.Entry<K, V>>();
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (entry == null) continue;
            entrySet.add(entry);
        }
        return entrySet;
    }

    public LimitedArrayCacheMap<K, V> clone() {
        LimitedArrayCacheMap<K, V> clone = new LimitedArrayCacheMap<K, V>(this.capacity);
        System.arraycopy(this.entries, 0, clone.entries, 0, this.capacity);
        clone.index = this.index;
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LimitedArrayCacheMap)) {
            return false;
        }
        LimitedArrayCacheMap other = (LimitedArrayCacheMap)o;
        if (this.getCapacity() != other.getCapacity()) {
            return false;
        }
        for (int i = 0; i < this.getCapacity(); ++i) {
            if ((this.entries[i] != null || other.entries[i] == null) && (this.entries[i] == null || this.entries[i].equals(other.entries[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int ret = 0;
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (entry == null) continue;
            ret += entry.hashCode();
        }
        return ret;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("LimitedArrayCacheMap[");
        boolean first = true;
        for (Map.Entry<K, V> e : this.entrySet()) {
            if (first) {
                s.append("{");
            } else {
                s.append(",{");
            }
            s.append(e.toString());
            s.append("}");
            first = false;
        }
        s.append("]");
        return s.toString();
    }

    public Stream<Map.Entry<K, V>> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.entrySet(), 0), false);
    }

    private void removeDuplicates() {
        for (int i = 0; i < this.capacity; ++i) {
            if (i == this.index || this.entries[i] == null || !this.entries[i].equals(this.entries[this.index])) continue;
            this.entries[i] = null;
        }
    }

    @Immutable
    private static final class ImmutableEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -4241056911694303514L;
        private final K key;
        private final V value;

        private ImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException("Immutable data");
        }

        @Override
        public boolean equals(@Nullable Object o) {
            return o != null && o instanceof Map.Entry && this.getKey().equals(((Map.Entry)o).getKey());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

