/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util.storage;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IndexedMap<K, V, I extends Comparable<I>>
extends Map<K, V>,
Serializable {
    public boolean isStrict();

    public boolean isMutable();

    public boolean areEntriesMutable();

    public Function<K, I> getIndexer();

    public I getIndex(@Nonnull K var1);

    @Nullable
    public V putAt(@Nonnull K var1, @Nonnull V var2, @Nullable I var3);

    @Nullable
    public K getKeyAt(@Nonnull I var1);

    @Nullable
    public V getValueAt(@Nonnull I var1);

    @Override
    @Nullable
    public V remove(@Nonnull I var1);

    public static interface IndexMapEntry<K, V, I extends Comparable<I>>
    extends Map.Entry<K, V>,
    Comparable<IndexMapEntry<K, V, I>>,
    Serializable {
        public I getIndex();

        @Override
        default public int compareTo(@Nonnull IndexMapEntry<K, V, I> other) {
            return this.getIndex().compareTo(other.getIndex());
        }

        public static abstract class IndexEntryBase<K, V, I extends Comparable<I>>
        implements IndexMapEntry<K, V, I> {
            private static final long serialVersionUID = -5154097056428766455L;
            private final K key;
            private final I index;
            private V value;

            IndexEntryBase(@Nonnull K key, @Nonnull V value, @Nonnull I index) {
                this.key = key;
                this.value = value;
                this.index = index;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public I getIndex() {
                return this.index;
            }

            V putValue(@Nonnull V newValue) {
                V ret = this.getValue();
                this.value = newValue;
                return ret;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof IndexEntryBase)) {
                    return false;
                }
                IndexEntryBase other = (IndexEntryBase)o;
                return Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getValue(), other.getValue()) && Objects.equals(this.getIndex(), other.getIndex());
            }

            @Override
            public int hashCode() {
                return this.getIndex().hashCode() ^ this.getKey().hashCode() ^ this.getValue().hashCode();
            }

            public String toString() {
                return this.getClass().getSimpleName() + "[" + this.getIndex() + "[" + this.getKey() + "=" + this.getValue() + "]]";
            }

            public static class SimpleImmutableIndexEntry<K, V, I extends Comparable<I>>
            extends IndexEntryBase<K, V, I> {
                private static final long serialVersionUID = 2533506876382702762L;

                public SimpleImmutableIndexEntry(@Nonnull K key, @Nonnull V value, @Nonnull I index) {
                    super(key, value, index);
                }

                public SimpleImmutableIndexEntry(@Nonnull K key, @Nonnull V value, @Nonnull Function<K, I> indexer) {
                    super(key, value, (Comparable)indexer.apply(key));
                }

                @Override
                public V setValue(@Nonnull V newValue) {
                    throw new UnsupportedOperationException("Immutable data");
                }
            }

            public static class SimpleMutableIndexEntry<K, V, I extends Comparable<I>>
            extends IndexEntryBase<K, V, I> {
                private static final long serialVersionUID = -2225795238508933466L;

                public SimpleMutableIndexEntry(@Nonnull K key, @Nonnull V value, @Nonnull I index) {
                    super(key, value, index);
                }

                public SimpleMutableIndexEntry(@Nonnull K key, @Nonnull V value, @Nonnull Function<K, I> indexer) {
                    super(key, value, (Comparable)indexer.apply(key));
                }

                @Override
                public V setValue(@Nonnull V newValue) {
                    return this.putValue(newValue);
                }
            }
        }
    }

    public static interface LimitedIndexedMap<K, V, I extends Comparable<I>>
    extends IndexedMap<K, V, I> {
        public int getCapacity();

        default public boolean checkBounds(int index) {
            if (index < 0 || index >= this.getCapacity()) {
                if (this.isStrict()) {
                    throw new IndexOutOfBoundsException("Index is out of bounds for map entry: " + index);
                }
                return true;
            }
            return false;
        }

        public static interface LongLIMap<K, V>
        extends LimitedIndexedMap<K, V, Long> {
        }

        public static interface IntegerLIMap<K, V>
        extends LimitedIndexedMap<K, V, Integer> {
        }

        public static interface ShortLIMap<K, V>
        extends LimitedIndexedMap<K, V, Short> {
        }

        public static interface ByteLIMap<K, V>
        extends LimitedIndexedMap<K, V, Byte> {
        }
    }
}

