/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco.helper;

import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;

public class DecoHelperThisOrThat
extends DecoBase {
    private int chance;
    private ChanceType chanceType;
    private DecoBase decoThis;
    private DecoBase decoThat;

    public DecoHelperThisOrThat(int chance, ChanceType chanceType, DecoBase decoThis, DecoBase decoThat) {
        this.chance = chance;
        this.chanceType = chanceType;
        this.decoThis = decoThis;
        this.decoThat = decoThat;
        if (!decoThis.properlyDefined()) {
            throw new RuntimeException();
        }
        if (!decoThat.properlyDefined()) {
            throw new RuntimeException();
        }
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        switch (this.chanceType) {
            case EQUALS_ZERO: {
                if (rand.nextInt(this.chance) == 0) {
                    this.decoThis.generate(biome, rtgWorld, rand, chunkPos, river, hasVillage);
                    break;
                }
                this.decoThat.generate(biome, rtgWorld, rand, chunkPos, river, hasVillage);
                break;
            }
            case NOT_EQUALS_ZERO: {
                if (rand.nextInt(this.chance) != 0) {
                    this.decoThis.generate(biome, rtgWorld, rand, chunkPos, river, hasVillage);
                    break;
                }
                this.decoThat.generate(biome, rtgWorld, rand, chunkPos, river, hasVillage);
                break;
            }
        }
    }

    public int getChance() {
        return this.chance;
    }

    public DecoHelperThisOrThat setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public ChanceType getChanceType() {
        return this.chanceType;
    }

    public DecoHelperThisOrThat setChanceType(ChanceType chanceType) {
        this.chanceType = chanceType;
        return this;
    }

    public static enum ChanceType {
        EQUALS_ZERO,
        NOT_EQUALS_ZERO;

    }
}

