/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome;

import java.util.Arrays;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import rtg.api.RTGAPI;
import rtg.api.util.CircularSearchCreator;
import rtg.api.world.biome.IRealisticBiome;
import rtg.world.gen.ChunkLandscape;

public final class BiomeAnalyzer {
    private static final int NO_BIOME = -1;
    private static final int MAX_BIOMES = 256;
    private boolean[] riverBiome = new boolean[256];
    private boolean[] oceanBiome = new boolean[256];
    private boolean[] swampBiome = new boolean[256];
    private boolean[] beachBiome = new boolean[256];
    private boolean[] landBiome = new boolean[256];
    private int[] preferredBeach;
    private IRealisticBiome scenicLakeBiome = RTGAPI.getRTGBiome(Biomes.field_76781_i);
    private IRealisticBiome scenicFrozenLakeBiome = RTGAPI.getRTGBiome(Biomes.field_76777_m);
    private SmoothingSearchStatus beachSearch;
    private SmoothingSearchStatus landSearch;
    private SmoothingSearchStatus oceanSearch;

    public BiomeAnalyzer() {
        this.initBiomes();
        this.setupBeachesForBiomes();
        this.setSearches();
    }

    public int[] xyinverted() {
        int i;
        int[] result = new int[256];
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                result[i * 16 + j] = j * 16 + i;
            }
        }
        for (i = 0; i < 256; ++i) {
            if (result[result[i]] == i) continue;
            throw new RuntimeException("" + i + " " + result[i] + " " + result[result[i]]);
        }
        return result;
    }

    private void initBiomes() {
        ForgeRegistries.BIOMES.getValuesCollection().forEach(biome -> {
            int id = Biome.func_185362_a((Biome)biome);
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                this.oceanBiome[id] = true;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                this.riverBiome[id] = true;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                this.swampBiome[id] = true;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                this.beachBiome[id] = true;
            } else {
                this.landBiome[id] = true;
            }
        });
    }

    private void setupBeachesForBiomes() {
        this.preferredBeach = new int[256];
        for (int i = 0; i < this.preferredBeach.length; ++i) {
            IRealisticBiome realisticBiome;
            Biome biome = Biome.func_150568_d((int)i);
            if (biome == null || (realisticBiome = RTGAPI.RTG_BIOMES.getValueAt(i)) == null) continue;
            this.preferredBeach[i] = realisticBiome.getBeachBiome().baseBiomeId();
        }
    }

    public void newRepair(Biome[] genLayerBiomes, int[] biomeNeighborhood, ChunkLandscape landscape) {
        int foundBiome;
        int biomeID;
        int i;
        IRealisticBiome[] jitteredBiomes = landscape.biome;
        float[] noise = landscape.noise;
        float[] riverStrength = landscape.river;
        for (int i2 = 0; i2 < 256; ++i2) {
            boolean canBeRiver;
            IRealisticBiome realisticBiome = RTGAPI.getRTGBiome(genLayerBiomes[i2]);
            int realisticBiomeId = realisticBiome.baseBiomeId();
            boolean bl = canBeRiver = (double)riverStrength[i2] > 0.7;
            jitteredBiomes[i2] = (double)noise[i2] > 61.5 ? realisticBiome : (canBeRiver && !this.oceanBiome[realisticBiomeId] && !this.swampBiome[realisticBiomeId] ? realisticBiome.getRiverBiome() : realisticBiome);
        }
        this.beachSearch.setNotHunted();
        this.beachSearch.setAbsent();
        float beachTop = 64.5f;
        for (i = 0; i < 256 && !this.beachSearch.isAbsent(); ++i) {
            float beachBottom = 61.5f;
            if (noise[i] < beachBottom || noise[i] > this.riverAdjusted(beachTop, riverStrength[i]) || this.swampBiome[biomeID = Biome.func_185362_a((Biome)jitteredBiomes[i].baseBiome())]) continue;
            if (this.beachSearch.isNotHunted()) {
                this.beachSearch.hunt(biomeNeighborhood);
                this.landSearch.hunt(biomeNeighborhood);
            }
            if ((foundBiome = this.beachSearch.biomes[i]) == -1) continue;
            int nearestLandBiome = this.landSearch.biomes[i];
            if (nearestLandBiome > -1) {
                foundBiome = this.preferredBeach[nearestLandBiome];
            }
            jitteredBiomes[i] = RTGAPI.getRTGBiome(foundBiome);
        }
        this.landSearch.setAbsent();
        this.landSearch.setNotHunted();
        for (i = 0; !(i >= 256 || this.landSearch.isAbsent() && this.beachSearch.isAbsent()); ++i) {
            int foundBiome2;
            int biomeID2;
            if (noise[i] < this.riverAdjusted(beachTop, riverStrength[i]) || this.landBiome[biomeID2 = Biome.func_185362_a((Biome)jitteredBiomes[i].baseBiome())] || this.swampBiome[biomeID2]) continue;
            if (this.landSearch.isNotHunted()) {
                this.landSearch.hunt(biomeNeighborhood);
            }
            if ((foundBiome2 = this.landSearch.biomes[i]) == -1) {
                if (this.beachSearch.isNotHunted()) {
                    this.beachSearch.hunt(biomeNeighborhood);
                }
                foundBiome2 = this.beachSearch.biomes[i];
            }
            if (foundBiome2 == -1) continue;
            jitteredBiomes[i] = RTGAPI.getRTGBiome(foundBiome2);
        }
        this.oceanSearch.setAbsent();
        this.oceanSearch.setNotHunted();
        for (i = 0; i < 256 && !this.oceanSearch.isAbsent(); ++i) {
            float oceanTop = 61.5f;
            if (noise[i] > oceanTop || this.oceanBiome[biomeID = Biome.func_185362_a((Biome)jitteredBiomes[i].baseBiome())] || this.swampBiome[biomeID] || this.riverBiome[biomeID]) continue;
            if (this.oceanSearch.isNotHunted()) {
                this.oceanSearch.hunt(biomeNeighborhood);
            }
            if ((foundBiome = this.oceanSearch.biomes[i]) == -1) continue;
            jitteredBiomes[i] = RTGAPI.getRTGBiome(foundBiome);
        }
        for (i = 0; i < 256; ++i) {
            int biomeID3 = Biome.func_185362_a((Biome)jitteredBiomes[i].baseBiome());
            if (!((double)noise[i] <= 61.5) || this.riverBiome[biomeID3] || this.oceanBiome[biomeID3] || this.swampBiome[biomeID3] || this.beachBiome[biomeID3]) continue;
            int riverReplacement = jitteredBiomes[i].getRiverBiome().baseBiomeId();
            jitteredBiomes[i] = riverReplacement == Biome.func_185362_a((Biome)Biomes.field_76777_m) ? this.scenicFrozenLakeBiome : this.scenicLakeBiome;
        }
    }

    private void setSearches() {
        this.beachSearch = new SmoothingSearchStatus(this.beachBiome);
        this.landSearch = new SmoothingSearchStatus(this.landBiome);
        this.oceanSearch = new SmoothingSearchStatus(this.oceanBiome);
    }

    private float riverAdjusted(float top, float river) {
        if (river >= 1.0f) {
            return top;
        }
        float erodedRiver = river / 0.09375f;
        if (erodedRiver <= 1.0f) {
            top = top * (1.0f - erodedRiver) + 62.0f * erodedRiver;
        }
        top = top * (1.0f - river) + 62.0f * river;
        return top;
    }

    private static final class SmoothingSearchStatus {
        private final int upperLeftFinding = 0;
        private final int upperRightFinding = 3;
        private final int lowerLeftFinding = 1;
        private final int lowerRightFinding = 4;
        private final int[] quadrantBiome = new int[4];
        private final float[] quadrantBiomeWeighting = new float[4];
        public int[] biomes = new int[256];
        private boolean absent = false;
        private boolean notHunted;
        private int[] findings = new int[9];
        private float[] weightings = new float[9];
        private boolean[] desired;
        private int arraySize;
        private int[] pattern;
        private int biomeCount;

        private SmoothingSearchStatus(boolean[] desired) {
            this.desired = desired;
        }

        private int size() {
            return 3;
        }

        private void hunt(int[] biomeNeighborhood) {
            this.clear();
            int oldArraySize = this.arraySize;
            this.arraySize = (int)Math.sqrt(biomeNeighborhood.length);
            if (this.arraySize * this.arraySize != biomeNeighborhood.length) {
                throw new RuntimeException("non-square array");
            }
            if (this.arraySize != oldArraySize) {
                this.pattern = new CircularSearchCreator().pattern((float)this.arraySize / 2.0f - 1.0f, this.arraySize);
            }
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    this.search(xOffset, zOffset, biomeNeighborhood);
                }
            }
            this.smoothBiomes();
        }

        private void search(int xOffset, int zOffset, int[] biomeNeighborhood) {
            int offset = xOffset * this.arraySize + zOffset;
            int location = (xOffset + 1) * this.size() + zOffset + 1;
            this.findings[location] = -1;
            this.weightings[location] = 2.0f;
            for (int i = 0; i < this.pattern.length; ++i) {
                int biome = biomeNeighborhood[this.pattern[i] + offset];
                if (!this.desired[biome]) continue;
                this.findings[location] = biome;
                this.weightings[location] = (float)Math.sqrt(this.pattern.length) - (float)Math.sqrt(i) + 2.0f;
                break;
            }
        }

        private void smoothBiomes() {
            this.smoothQuadrant(this.biomeIndex(0, 0), 0);
            this.smoothQuadrant(this.biomeIndex(8, 0), 3);
            this.smoothQuadrant(this.biomeIndex(0, 8), 1);
            this.smoothQuadrant(this.biomeIndex(8, 8), 4);
        }

        private void smoothQuadrant(int biomesOffset, int findingsOffset) {
            int upperLeft = this.findings[0 + findingsOffset];
            int upperRight = this.findings[3 + findingsOffset];
            int lowerLeft = this.findings[1 + findingsOffset];
            int lowerRight = this.findings[4 + findingsOffset];
            if (upperLeft == upperRight && upperLeft == lowerLeft && upperLeft == lowerRight) {
                for (int x = 0; x < 8; ++x) {
                    for (int z = 0; z < 8; ++z) {
                        this.biomes[this.biomeIndex((int)x, (int)z) + biomesOffset] = upperLeft;
                    }
                }
                return;
            }
            this.biomeCount = 0;
            this.addBiome(upperLeft);
            this.addBiome(upperRight);
            this.addBiome(lowerLeft);
            this.addBiome(lowerRight);
            for (int x = 0; x < 8; ++x) {
                for (int z = 0; z < 8; ++z) {
                    this.addBiome(lowerRight);
                    for (int i = 0; i < 4; ++i) {
                        this.quadrantBiomeWeighting[i] = 0.0f;
                    }
                    this.addWeight(upperLeft, this.weightings[0 + findingsOffset] * (float)(7 - x) * (float)(7 - z));
                    this.addWeight(upperRight, this.weightings[3 + findingsOffset] * (float)x * (float)(7 - z));
                    this.addWeight(lowerLeft, this.weightings[1 + findingsOffset] * (float)(7 - x) * (float)z);
                    this.addWeight(lowerRight, this.weightings[4 + findingsOffset] * (float)x * (float)z);
                    this.biomes[this.biomeIndex((int)x, (int)z) + biomesOffset] = this.preferredBiome();
                }
            }
        }

        private void addBiome(int biome) {
            for (int i = 0; i < this.biomeCount; ++i) {
                if (biome != this.quadrantBiome[i]) continue;
                return;
            }
            this.quadrantBiome[this.biomeCount++] = biome;
        }

        private void addWeight(int biome, float weight) {
            for (int i = 0; i < this.biomeCount; ++i) {
                if (biome != this.quadrantBiome[i]) continue;
                int n = i;
                this.quadrantBiomeWeighting[n] = this.quadrantBiomeWeighting[n] + weight;
                return;
            }
        }

        private int preferredBiome() {
            float bestWeight = 0.0f;
            int result = -2;
            for (int i = 0; i < this.biomeCount; ++i) {
                if (!(this.quadrantBiomeWeighting[i] > bestWeight)) continue;
                bestWeight = this.quadrantBiomeWeighting[i];
                result = this.quadrantBiome[i];
            }
            return result;
        }

        private int biomeIndex(int x, int z) {
            return x * 16 + z;
        }

        private void clear() {
            Arrays.fill(this.findings, -1);
        }

        private boolean isAbsent() {
            return this.absent;
        }

        private void setAbsent() {
            this.absent = false;
        }

        private boolean isNotHunted() {
            return this.notHunted;
        }

        private void setNotHunted() {
            this.notHunted = true;
        }
    }
}

