/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.world.RTGWorld;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPOrchard
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.orchard.orNull();
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeBOPOrchard() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPOrchard(58.0f, 67.0f, 25.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPOrchard(this.getConfig(), RealisticBiomeBOPOrchard.biome.field_76752_A, RealisticBiomeBOPOrchard.biome.field_76753_B);
    }

    @Override
    public void initDecos() {
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.getDistribution().setNoiseDivisor(80.0f);
        decoFallenTree.getDistribution().setNoiseFactor(60.0f);
        decoFallenTree.getDistribution().setNoiseAddend(-15.0f);
        decoFallenTree.setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE);
        decoFallenTree.setLogConditionChance(10);
        decoFallenTree.setLogBlock(Blocks.field_150364_r.func_176223_P());
        decoFallenTree.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        decoFallenTree.setMinSize(2);
        decoFallenTree.setMaxSize(3);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
    }

    public static class SurfaceBOPOrchard
    extends SurfaceBase {
        public SurfaceBOPOrchard(BiomeConfig config, IBlockState top, IBlockState filler) {
            super(config, top, filler);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPOrchard
    extends TerrainBase {
        private float minHeight;
        private float maxHeight;
        private float hillStrength;

        public TerrainBOPOrchard(float minHeight, float maxHeight, float hillStrength) {
            this.minHeight = minHeight;
            this.maxHeight = maxHeight > this.rollingHillsMaxHeight ? this.rollingHillsMaxHeight : (maxHeight < this.minHeight ? this.rollingHillsMaxHeight : maxHeight);
            this.hillStrength = hillStrength;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPOrchard.terrainRollingHills(x, y, rtgWorld, river, this.hillStrength, this.maxHeight, this.groundNoiseAmplitudeHills, 4.0f);
        }
    }
}

