/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.candyworld;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.candyworld.RealisticBiomeCWBase;

public class RealisticBiomeCWGummySwamp
extends RealisticBiomeCWBase {
    public RealisticBiomeCWGummySwamp(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaForest();
    }

    @Override
    public SurfaceBase initSurface() {
        IBlockState GUMMY_GREEN = BlockUtil.getBlockStateFromCfgString("candymod:gummy_block[type=green]");
        IBlockState GUMMY_ORANGE = BlockUtil.getBlockStateFromCfgString("candymod:gummy_block[type=orange]");
        IBlockState GUMMY_RED = BlockUtil.getBlockStateFromCfgString("candymod:gummy_block[type=red]");
        IBlockState GUMMY_WHITE = BlockUtil.getBlockStateFromCfgString("candymod:gummy_block[type=white]");
        IBlockState GUMMY_YELLOW = BlockUtil.getBlockStateFromCfgString("candymod:gummy_block[type=yellow]");
        IBlockState SOLID_GUMMY_GREEN = BlockUtil.getBlockStateFromCfgString("candymod:hardened_gummy_block[type=green]");
        IBlockState SOLID_GUMMY_ORANGE = BlockUtil.getBlockStateFromCfgString("candymod:hardened_gummy_block[type=orange]");
        IBlockState SOLID_GUMMY_RED = BlockUtil.getBlockStateFromCfgString("candymod:hardened_gummy_block[type=red]");
        IBlockState SOLID_GUMMY_WHITE = BlockUtil.getBlockStateFromCfgString("candymod:hardened_gummy_block[type=white]");
        IBlockState SOLID_GUMMY_YELLOW = BlockUtil.getBlockStateFromCfgString("candymod:hardened_gummy_block[type=yellow]");
        return new SurfaceVanillaForest(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, GUMMY_WHITE, 0.5f, GUMMY_YELLOW, 0.2f, GUMMY_ORANGE, -0.2f, GUMMY_GREEN, -0.5f, SOLID_GUMMY_WHITE, SOLID_GUMMY_YELLOW, SOLID_GUMMY_ORANGE, SOLID_GUMMY_GREEN);
    }

    public static class SurfaceVanillaForest
    extends SurfaceBase {
        private float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private IBlockState mixBlock;
        private float mixHeight;
        private IBlockState mix2Block;
        private float mix2Height;
        private IBlockState mix3Block;
        private float mix3Height;
        private IBlockState mix4Block;
        private float mix4Height;
        private IBlockState mixFillBlock;
        private IBlockState mixFill2Block;
        private IBlockState mixFill3Block;
        private IBlockState mixFill4Block;

        public SurfaceVanillaForest(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mix, float mixHeight, IBlockState mix2, float mix2Height, IBlockState mix3, float mix3Height, IBlockState mix4, float mix4Height, IBlockState mixFill, IBlockState mixFill2, IBlockState mixFill3, IBlockState mixFill4) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mixBlock = mix;
            this.mixHeight = mixHeight;
            this.mix2Block = mix2;
            this.mix2Height = mix2Height;
            this.mix3Block = mix3;
            this.mix3Height = mix3Height;
            this.mix4Block = mix4;
            this.mix4Height = mix4Height;
            this.mixFillBlock = mixFill;
            this.mixFill2Block = mixFill2;
            this.mixFill3Block = mixFill3;
            this.mixFill4Block = mixFill4;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            IBlockState mix_filler = this.fillerBlock;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.topBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    float mixNoise = simplex.noise2f((float)i / 12.0f, (float)j / 12.0f);
                    if (mixNoise < this.mix4Height) {
                        primer.func_177855_a(x, k, z, this.mix4Block);
                        mix_filler = this.mixFill4Block;
                        continue;
                    }
                    if (mixNoise < this.mix3Height) {
                        primer.func_177855_a(x, k, z, this.mix3Block);
                        mix_filler = this.mixFill3Block;
                        continue;
                    }
                    if (mixNoise < this.mix2Height) {
                        primer.func_177855_a(x, k, z, this.mix2Block);
                        mix_filler = this.mixFill2Block;
                        continue;
                    }
                    if (mixNoise < this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        mix_filler = this.mixFillBlock;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                primer.func_177855_a(x, k, z, mix_filler);
            }
        }
    }

    public static class TerrainVanillaForest
    extends TerrainBase {
        private float hillStrength = 10.0f;

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            this.groundNoise = TerrainVanillaForest.groundNoise(x, y, this.groundVariation, rtgWorld);
            float m = TerrainVanillaForest.hills(x, y, this.hillStrength, rtgWorld);
            float floNoise = 65.0f + this.groundNoise + m;
            return TerrainVanillaForest.riverized(floNoise, river);
        }
    }
}

