/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.collection.DecoCollectionIceTrees;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeVanillaIcePlainsSpikes
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_185445_W;
    public static Biome river = Biomes.field_76777_m;

    public RealisticBiomeVanillaIcePlainsSpikes() {
        super(biome, RealisticBiomeBase.RiverType.FROZEN, RealisticBiomeBase.BeachType.COLD);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_ICE_TREES).set(true);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaIcePlainsSpikes();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaIcePlainsSpikes(this.getConfig(), RealisticBiomeVanillaIcePlainsSpikes.biome.field_76752_A, RealisticBiomeVanillaIcePlainsSpikes.biome.field_76753_B, RealisticBiomeVanillaIcePlainsSpikes.biome.field_76752_A, RealisticBiomeVanillaIcePlainsSpikes.biome.field_76752_A);
    }

    @Override
    public void initDecos() {
        if (this.getConfig().ALLOW_ICE_TREES.get()) {
            this.addDecoCollection(new DecoCollectionIceTrees(this.getConfig()));
        }
    }

    public static class SurfaceVanillaIcePlainsSpikes
    extends SurfaceBase {
        private IBlockState cliffBlock1;
        private IBlockState cliffBlock2;

        public SurfaceVanillaIcePlainsSpikes(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState cliff1, IBlockState cliff2) {
            super(config, top, filler);
            this.cliffBlock1 = cliff1;
            this.cliffBlock2 = cliff2;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        primer.func_177855_a(x, k, z, rand.nextInt(3) == 0 ? this.cliffBlock2 : this.cliffBlock1);
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.cliffBlock1);
                    continue;
                }
                if (depth == 0 && k > 61) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaIcePlainsSpikes
    extends TerrainBase {
        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaIcePlainsSpikes.terrainPlains(x, y, rtgWorld, river, 160.0f, 10.0f, 60.0f, 200.0f, 65.0f);
        }
    }
}

