/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.RTG;
import rtg.RTGConfig;
import rtg.api.RTGAPI;
import rtg.api.util.LimitedArrayCacheMap;
import rtg.api.util.Logger;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.gen.RTGChunkGenSettings;
import rtg.api.world.gen.feature.WorldGenPond;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.BiomeAnalyzer;
import rtg.world.gen.ChunkLandscape;
import rtg.world.gen.MapGenCavesRTG;
import rtg.world.gen.MapGenRavineRTG;
import rtg.world.gen.MesaBiomeCombiner;
import rtg.world.gen.structure.WoodlandMansionRTG;

public class ChunkGeneratorRTG
implements IChunkGenerator {
    public final RTGWorld rtgWorld;
    private final RTGChunkGenSettings settings;
    private final MapGenBase caveGenerator;
    private final MapGenBase ravineGenerator;
    private final MapGenStronghold strongholdGenerator;
    private final WoodlandMansionRTG woodlandMansionGenerator;
    private final MapGenMineshaft mineshaftGenerator;
    private final MapGenVillage villageGenerator;
    private final MapGenScatteredFeature scatteredFeatureGenerator;
    private final StructureOceanMonument oceanMonumentGenerator;
    private final World world;
    private final LimitedArrayCacheMap<ChunkPos, ChunkLandscape> landscapeCache = new LimitedArrayCacheMap(1024);
    private final int sampleSize = 8;
    private final int sampleArraySize = 21;
    private final int[] biomeData = new int[441];
    private final float[] weightedBiomes = new float[256];
    private final float[][] weightings = new float[441][256];
    private final MesaBiomeCombiner mesaCombiner = new MesaBiomeCombiner();
    private BiomeAnalyzer analyzer = new BiomeAnalyzer();
    private int[] xyinverted = this.analyzer.xyinverted();
    private boolean mapFeaturesEnabled;
    private Random rand;
    private Biome[] baseBiomesList;

    public ChunkGeneratorRTG(RTGWorld rtgWorld) {
        Logger.debug("Instantiating CPRTG using generator settings: {}", rtgWorld.world().func_72912_H().func_82571_y());
        this.world = rtgWorld.world();
        this.rtgWorld = rtgWorld;
        this.settings = rtgWorld.getGeneratorSettings();
        this.rand = new Random(rtgWorld.seed());
        this.rtgWorld.setRandom(this.rand);
        this.mapFeaturesEnabled = this.world.func_72912_H().func_76089_r();
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCavesRTG(this.settings.caveChance, this.settings.caveDensity), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavineRTG(this.settings.ravineChance), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(StructureType.VILLAGE.getSettings(this.settings)), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(StructureType.STRONGHOLD.getSettings(this.settings)), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.woodlandMansionGenerator = new WoodlandMansionRTG(this, StructureType.MANSION.getSettings(this.settings));
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(StructureType.MINESHAFT.getSettings(this.settings)), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)new MapGenScatteredFeature(StructureType.TEMPLE.getSettings(this.settings)), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)new StructureOceanMonument(StructureType.MONUMENT.getSettings(this.settings)), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.baseBiomesList = new Biome[256];
        this.setWeightings();
        Logger.debug("FINISHED instantiating CPRTG.", new Object[0]);
    }

    public Chunk func_185932_a(int cx, int cz) {
        ChunkPos chunkPos = new ChunkPos(cx, cz);
        BlockPos blockPos = new BlockPos(cx * 16, 0, cz * 16);
        BiomeProvider biomeProvider = this.world.func_72959_q();
        this.rand.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        ChunkLandscape landscape = this.getLandscape(biomeProvider, chunkPos);
        this.generateTerrain(primer, landscape.noise);
        for (int i = 0; i < 256; ++i) {
            this.baseBiomesList[i] = landscape.biome[i].baseBiome();
        }
        ISimplexData2D jitterData = SimplexData2D.newDisk();
        IRealisticBiome[] jitteredBiomes = new IRealisticBiome[256];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int x = blockPos.func_177958_n() + i;
                int z = blockPos.func_177952_p() + j;
                this.rtgWorld.simplexInstance(0).multiEval2D(x, z, jitterData);
                int pX = (int)Math.round((double)x + jitterData.getDeltaX() * (double)RTGConfig.surfaceBlendRadius());
                int pZ = (int)Math.round((double)z + jitterData.getDeltaY() * (double)RTGConfig.surfaceBlendRadius());
                IRealisticBiome actualbiome = landscape.biome[(x & 0xF) * 16 + (z & 0xF)];
                IRealisticBiome jitterbiome = landscape.biome[(pX & 0xF) * 16 + (pZ & 0xF)];
                jitteredBiomes[i * 16 + j] = actualbiome.getConfig().SURFACE_BLEED_IN.get() && jitterbiome.getConfig().SURFACE_BLEED_OUT.get() ? jitterbiome : actualbiome;
            }
        }
        this.replaceBiomeBlocks(cx, cz, primer, jitteredBiomes, this.baseBiomesList, landscape.noise);
        if (this.settings.useCaves) {
            this.caveGenerator.func_186125_a(this.world, cx, cz, primer);
        }
        if (this.settings.useRavines) {
            this.ravineGenerator.func_186125_a(this.world, cx, cz, primer);
        }
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_186125_a(this.world, cx, cz, primer);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_186125_a(this.world, cx, cz, primer);
            }
            if (this.settings.useVillages) {
                this.villageGenerator.func_186125_a(this.world, cx, cz, primer);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.world, cx, cz, primer);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.world, cx, cz, primer);
            }
            if (this.settings.useMansions) {
                this.woodlandMansionGenerator.func_186125_a(this.world, cx, cz, primer);
            }
        }
        Chunk chunk = new Chunk(this.world, primer, cx, cz);
        byte[] abyte1 = chunk.func_76605_m();
        for (int i = 0; i < abyte1.length; ++i) {
            byte b;
            abyte1[i] = b = (byte)Biome.func_185362_a((Biome)this.baseBiomesList[this.xyinverted[i]]);
        }
        chunk.func_76616_a(abyte1);
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(ChunkPrimer primer, float[] noise) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = (int)noise[x * 16 + z];
                for (int y = 0; y < 256; ++y) {
                    if (y > height) {
                        if (y < this.settings.seaLevel) {
                            primer.func_177855_a(x, y, z, Blocks.field_150355_j.func_176223_P());
                            continue;
                        }
                        primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                }
            }
        }
    }

    private void replaceBiomeBlocks(int cx, int cz, ChunkPrimer primer, IRealisticBiome[] biomes, Biome[] base, float[] noise) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)cx, (int)cz, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int worldX = cx * 16;
        int worldZ = cz * 16;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mpos.func_181079_c(worldX + x, 0, worldZ + z);
                float river = -TerrainBase.getRiverStrength((BlockPos)mpos, this.rtgWorld);
                int depth = -1;
                biomes[x * 16 + z].rReplace(primer, (BlockPos)mpos, x, z, depth, this.rtgWorld, noise, river, base);
                if (this.settings.bedrockLayers > 1) {
                    for (int bl = 9; bl >= 0; --bl) {
                        if (bl > this.rand.nextInt(this.settings.bedrockLayers)) continue;
                        primer.func_177855_a(x, bl, z, Blocks.field_150357_h.func_176223_P());
                    }
                    continue;
                }
                primer.func_177855_a(x, 0, z, Blocks.field_150357_h.func_176223_P());
            }
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockPos pos;
        int surfacechance;
        long nextchance;
        BlockFalling.field_149832_M = true;
        BiomeProvider biomeProvider = this.world.func_72959_q();
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        BlockPos blockPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        BlockPos offsetpos = blockPos.func_177982_a(8, 0, 8);
        IRealisticBiome biome = RTGAPI.getRTGBiome(biomeProvider.func_180631_a(blockPos.func_177982_a(16, 0, 16)));
        this.rand.setSeed(this.rtgWorld.getChunkSeed(chunkX, chunkZ));
        boolean hasVillage = false;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useVillages) {
                hasVillage = this.villageGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useMansions) {
                this.woodlandMansionGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
        }
        if (this.settings.useWaterLakes && this.settings.waterLakeChance > 0 && !hasVillage) {
            nextchance = this.rand.nextLong();
            surfacechance = this.settings.getSurfaceWaterLakeChance(biome.waterLakeMult());
            pos = offsetpos.func_177982_a(this.rand.nextInt(16), 0, this.rand.nextInt(16));
            if (surfacechance > 0 && nextchance % (long)surfacechance == 0L) {
                if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                    new WorldGenPond(Blocks.field_150355_j.func_176223_P()).func_180709_b(this.world, this.rand, pos.func_177981_b(this.rand.nextInt(256)));
                }
            } else if (nextchance % (long)this.settings.waterLakeChance == 0L && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, pos.func_177981_b(this.rand.nextInt(50) + 4));
            }
        }
        if (this.settings.useLavaLakes && this.settings.lavaLakeChance > 0 && !hasVillage) {
            nextchance = this.rand.nextLong();
            surfacechance = this.settings.getSurfaceLavaLakeChance(biome.lavaLakeMult());
            pos = offsetpos.func_177982_a(this.rand.nextInt(16), 0, this.rand.nextInt(16));
            if (surfacechance > 0 && nextchance % (long)surfacechance == 0L) {
                if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
                    new WorldGenPond(Blocks.field_150353_l.func_176223_P()).func_180709_b(this.world, this.rand, pos.func_177981_b(this.rand.nextInt(256)));
                }
            } else if (nextchance % (long)this.settings.lavaLakeChance == 0L && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, pos.func_177981_b(this.rand.nextInt(50) + 4));
            }
        }
        if (this.settings.useDungeons && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int i = 0; i < this.settings.dungeonChance; ++i) {
                new WorldGenDungeons().func_180709_b(this.world, this.rand, offsetpos.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(256), this.rand.nextInt(16)));
            }
        }
        float river = -TerrainBase.getRiverStrength(blockPos.func_177982_a(16, 0, 16), this.rtgWorld);
        if (RTG.decorationsDisable() || biome.getConfig().DISABLE_RTG_DECORATIONS.get()) {
            if (river > 0.9f) {
                biome.getRiverBiome().baseBiome().func_180624_a(this.world, this.rand, blockPos);
            } else {
                biome.baseBiome().func_180624_a(this.world, this.rand, blockPos);
            }
        } else if (river > 0.9f) {
            biome.getRiverBiome().rDecorate(this.rtgWorld, this.rand, chunkPos, river, hasVillage);
        } else {
            biome.rDecorate(this.rtgWorld, this.rand, chunkPos, river, hasVillage);
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome.baseBiome(), (int)(blockPos.func_177958_n() + 8), (int)(blockPos.func_177952_p() + 8), (int)16, (int)16, (Random)this.rand);
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos freezePos = this.world.func_175725_q(offsetpos.func_177982_a(x, 0, z)).func_177977_b();
                    if (this.world.func_175675_v(freezePos)) {
                        this.world.func_180501_a(freezePos, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    BlockPos surfacePos = this.world.func_175672_r(offsetpos.func_177982_a(x, 0, z));
                    if (!this.settings.useSnowLayers) continue;
                    BlockPos checkPos = surfacePos.func_177981_b(32);
                    while (checkPos.func_177956_o() >= surfacePos.func_177956_o()) {
                        IBlockState below;
                        float temp;
                        if (this.world.func_180495_p(checkPos).func_185904_a() == Material.field_151579_a && (temp = biomeProvider.func_180631_a(surfacePos).func_180626_a(checkPos)) <= this.settings.getClampedSnowLayerTemp() && ((below = this.world.func_180495_p(checkPos.func_177977_b())).func_185913_b() || below.func_185904_a() == Material.field_151584_j)) {
                            this.world.func_180501_a(checkPos, Blocks.field_150431_aC.func_176223_P(), 2);
                            checkPos = checkPos.func_177977_b();
                        }
                        checkPos = checkPos.func_177977_b();
                    }
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        boolean flag = false;
        if (this.settings.useMonuments && this.mapFeaturesEnabled && chunkIn.func_177416_w() < 3600L) {
            flag = this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        if (this.mapFeaturesEnabled) {
            if (creatureType == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.func_175798_a(pos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (creatureType == EnumCreatureType.MONSTER && this.settings.useMonuments && this.oceanMonumentGenerator.func_175796_a(this.world, pos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        }
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if (!this.mapFeaturesEnabled) {
            return null;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null) {
            return this.woodlandMansionGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Temple".equals(structureName) && this.scatteredFeatureGenerator != null) {
            this.scatteredFeatureGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        return null;
    }

    public void func_180514_a(Chunk chunk, int cx, int cz) {
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_186125_a(this.world, cx, cz, null);
            }
            if (this.settings.useVillages) {
                this.villageGenerator.func_186125_a(this.world, cx, cz, null);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_186125_a(this.world, cx, cz, null);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.world, cx, cz, null);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.world, cx, cz, null);
            }
            if (this.settings.useMansions) {
                this.woodlandMansionGenerator.func_186125_a(this.world, cx, cz, null);
            }
        }
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_175795_b(pos);
        }
        if ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null) {
            return this.woodlandMansionGenerator.func_175795_b(pos);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_175795_b(pos);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_175795_b(pos);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null && this.scatteredFeatureGenerator.func_175795_b(pos);
    }

    private void setWeightings() {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                float limit = (float)Math.pow(3136.0, 0.7);
                for (int mapX = 0; mapX < 21; ++mapX) {
                    for (int mapZ = 0; mapZ < 21; ++mapZ) {
                        float xDist = x - (mapX - 8) * 8;
                        float zDist = z - (mapZ - 8) * 8;
                        float distanceSquared = xDist * xDist + zDist * zDist;
                        float distance = (float)Math.pow(distanceSquared, 0.7);
                        float weight = 1.0f - distance / limit;
                        if (weight < 0.0f) {
                            weight = 0.0f;
                        }
                        this.weightings[mapX * 21 + mapZ][x * 16 + z] = weight;
                    }
                }
            }
        }
    }

    public ChunkLandscape getLandscape(BiomeProvider biomeProvider, ChunkPos chunkPos) {
        BlockPos blockPos = new BlockPos(chunkPos.field_77276_a * 16, 0, chunkPos.field_77275_b * 16);
        ChunkLandscape landscape = this.landscapeCache.get(chunkPos);
        if (landscape == null) {
            landscape = this.generateLandscape(biomeProvider, blockPos);
            this.landscapeCache.put(chunkPos, landscape);
        }
        return landscape;
    }

    private synchronized ChunkLandscape generateLandscape(BiomeProvider biomeProvider, BlockPos blockPos) {
        ChunkLandscape landscape = new ChunkLandscape();
        this.getNewerNoise(biomeProvider, blockPos.func_177958_n(), blockPos.func_177952_p(), landscape);
        Biome[] biomes = new Biome[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                biomes[x * 16 + z] = biomeProvider.func_180631_a(blockPos.func_177982_a(x, 0, z));
            }
        }
        this.analyzer.newRepair(biomes, this.biomeData, landscape);
        return landscape;
    }

    private synchronized void getNewerNoise(BiomeProvider biomeProvider, int worldX, int worldZ, ChunkLandscape landscape) {
        int z;
        int x;
        for (int x2 = -8; x2 < 13; ++x2) {
            for (int z2 = -8; z2 < 13; ++z2) {
                this.biomeData[(x2 + 8) * 21 + (z2 + 8)] = Biome.func_185362_a((Biome)biomeProvider.func_180631_a(new BlockPos(worldX + x2 * 8, 0, worldZ + z2 * 8)));
            }
        }
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(worldX, 0, worldZ);
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                float totalWeight = 0.0f;
                for (int mapX = 0; mapX < 21; ++mapX) {
                    for (int mapZ = 0; mapZ < 21; ++mapZ) {
                        float weight = this.weightings[mapX * 21 + mapZ][x * 16 + z];
                        if (!(weight > 0.0f)) continue;
                        totalWeight += weight;
                        int n = this.biomeData[mapX * 21 + mapZ];
                        this.weightedBiomes[n] = this.weightedBiomes[n] + weight;
                    }
                }
                int biomeIndex = 0;
                while (biomeIndex < this.weightedBiomes.length) {
                    int n = biomeIndex++;
                    this.weightedBiomes[n] = this.weightedBiomes[n] / totalWeight;
                }
                this.mesaCombiner.adjust(this.weightedBiomes);
                landscape.noise[x * 16 + z] = 0.0f;
                float river = TerrainBase.getRiverStrength((BlockPos)mpos.func_181079_c(worldX + x, 0, worldZ + z), this.rtgWorld);
                landscape.river[x * 16 + z] = -river;
                for (int i = 0; i < 256; ++i) {
                    if (!(this.weightedBiomes[i] > 0.0f)) continue;
                    int n = x * 16 + z;
                    landscape.noise[n] = landscape.noise[n] + RTGAPI.getRTGBiome(i).rNoise(this.rtgWorld, worldX + x, worldZ + z, this.weightedBiomes[i], river + 1.0f) * this.weightedBiomes[i];
                    this.weightedBiomes[i] = 0.0f;
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                BlockPos pos = new BlockPos(worldX + (x - 7) * 8 + 4, 0, worldZ + (z - 7) * 8 + 4);
                landscape.biome[x * 16 + z] = RTGAPI.getRTGBiome(biomeProvider.func_180631_a(pos));
            }
        }
    }

    private static enum StructureType {
        MINESHAFT,
        MONUMENT,
        STRONGHOLD,
        TEMPLE,
        VILLAGE,
        MANSION;


        Map<String, String> getSettings(RTGChunkGenSettings settings) {
            HashMap<String, String> ret = new HashMap<String, String>();
            if (this == MINESHAFT) {
                ret.put("chance", String.valueOf(settings.mineShaftChance));
                return ret;
            }
            if (this == MONUMENT) {
                ret.put("separation", String.valueOf(settings.monumentSeparation));
                ret.put("spacing", String.valueOf(settings.monumentSpacing));
                return ret;
            }
            if (this == STRONGHOLD) {
                ret.put("count", String.valueOf(settings.strongholdCount));
                ret.put("distance", String.valueOf(settings.strongholdDistance));
                ret.put("spread", String.valueOf(settings.strongholdSpread));
                return ret;
            }
            if (this == TEMPLE) {
                ret.put("distance", String.valueOf(settings.templeDistance));
                return ret;
            }
            if (this == VILLAGE) {
                ret.put("distance", String.valueOf(settings.villageDistance));
                ret.put("size", String.valueOf(settings.villageSize));
                return ret;
            }
            if (this == MANSION) {
                ret.put("spacing", String.valueOf(settings.mansionSpacing));
                ret.put("separation", String.valueOf(settings.mansionSeparation));
                return ret;
            }
            return ret;
        }
    }
}

