/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.world.gen;

import java.util.Random;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.stevekunglib.world.gen.WorldGenAbstractHugeTrees;

public abstract class WorldGenAbstractMegaJungle
extends WorldGenAbstractHugeTrees {
    private final IBlockState log;

    public WorldGenAbstractMegaJungle(int baseHeight, int extraRandomHeight, IBlockState log, IBlockState leaves) {
        super(baseHeight, extraRandomHeight, leaves);
        this.log = log;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i = this.getHeight(rand);
        if (!this.ensureGrowable(world, pos, i)) {
            return false;
        }
        this.createCrown(world, pos.func_177981_b(i));
        for (int j = pos.func_177956_o() + i - 2 - rand.nextInt(4); j > pos.func_177956_o() + i / 2; j -= 2 + rand.nextInt(4)) {
            float f = rand.nextFloat() * ((float)Math.PI * 2);
            int k = pos.func_177958_n() + (int)(0.5f + MathHelper.func_76134_b((float)f) * 4.0f);
            int l = pos.func_177952_p() + (int)(0.5f + MathHelper.func_76126_a((float)f) * 4.0f);
            for (int i1 = 0; i1 < 5; ++i1) {
                k = pos.func_177958_n() + (int)(1.5f + MathHelper.func_76134_b((float)f) * (float)i1);
                l = pos.func_177952_p() + (int)(1.5f + MathHelper.func_76126_a((float)f) * (float)i1);
                this.func_175903_a(world, new BlockPos(k, j - 3 + i1 / 2, l), this.log);
            }
            int j2 = 1 + rand.nextInt(2);
            for (int k1 = j - j2; k1 <= j; ++k1) {
                int l1 = k1 - j;
                this.growLeavesLayer(world, new BlockPos(k, k1, l), 1 - l1);
            }
        }
        for (int i2 = 0; i2 < i; ++i2) {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos = pos.func_177981_b(i2);
            if (this.isAirLeaves(world, blockpos)) {
                this.func_175903_a(world, blockpos, this.log);
                if (i2 > 0) {
                    this.placeVine(world, rand, blockpos.func_177976_e(), BlockVine.field_176278_M);
                    this.placeVine(world, rand, blockpos.func_177978_c(), BlockVine.field_176279_N);
                }
            }
            if (i2 >= i - 1) continue;
            BlockPos blockpos1 = blockpos.func_177974_f();
            if (this.isAirLeaves(world, blockpos1)) {
                this.func_175903_a(world, blockpos1, this.log);
                if (i2 > 0) {
                    this.placeVine(world, rand, blockpos1.func_177974_f(), BlockVine.field_176280_O);
                    this.placeVine(world, rand, blockpos1.func_177978_c(), BlockVine.field_176279_N);
                }
            }
            if (this.isAirLeaves(world, blockpos2 = blockpos.func_177968_d().func_177974_f())) {
                this.func_175903_a(world, blockpos2, this.log);
                if (i2 > 0) {
                    this.placeVine(world, rand, blockpos2.func_177974_f(), BlockVine.field_176280_O);
                    this.placeVine(world, rand, blockpos2.func_177968_d(), BlockVine.field_176273_b);
                }
            }
            if (!this.isAirLeaves(world, blockpos3 = blockpos.func_177968_d())) continue;
            this.func_175903_a(world, blockpos3, this.log);
            if (i2 <= 0) continue;
            this.placeVine(world, rand, blockpos3.func_177976_e(), BlockVine.field_176278_M);
            this.placeVine(world, rand, blockpos3.func_177968_d(), BlockVine.field_176273_b);
        }
        return true;
    }

    private void placeVine(World world, Random rand, BlockPos pos, PropertyBool bool) {
        if (rand.nextInt(3) > 0 && world.func_175623_d(pos)) {
            this.func_175903_a(world, pos, this.getVine().func_177226_a((IProperty)bool, (Comparable)Boolean.valueOf(true)));
        }
    }

    private void createCrown(World world, BlockPos pos) {
        for (int j = -2; j <= 0; ++j) {
            this.growLeavesLayerStrict(world, pos.func_177981_b(j), 3 - j);
        }
    }

    private boolean isAirLeaves(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }

    protected abstract IBlockState getVine();
}

