/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttainedDropsHelper
extends IECompatModule {
    public static final String AD_MODID = "attaineddrops2";
    private static Int2ObjectMap<ItemStack[]> outputMap = new Int2ObjectOpenHashMap();
    private static Int2ObjectMap<IBlockState> bulbMap = new Int2ObjectOpenHashMap();
    private Item seed;
    private Block plant;
    private Block bulb;
    private Block soil;
    private Item soilItem;

    @Override
    public void preInit() {
    }

    @Override
    public void registerRecipes() {
    }

    @Override
    public void init() {
        this.seed = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(AD_MODID, "seed"));
        this.plant = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(AD_MODID, "plant"));
        this.bulb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(AD_MODID, "bulb"));
        this.soil = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(AD_MODID, "soil"));
        this.soilItem = Item.func_150898_a((Block)this.soil);
        this.addTypes();
        BelljarHandler.registerHandler(new BelljarHandler.IPlantHandler(){

            @Override
            public boolean isCorrectSoil(ItemStack seed, ItemStack soil) {
                return soil.func_77973_b() == AttainedDropsHelper.this.soilItem && soil.func_77960_j() > 0 && soil.func_77960_j() <= 15;
            }

            @Override
            public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
                return ((double)growth < 0.5 ? 0.003125f : 0.0015625f) * fertilizer;
            }

            @Override
            public float resetGrowth(ItemStack seed, ItemStack soil, float growth, TileEntity tile, boolean render) {
                return 0.5f;
            }

            @Override
            public ItemStack[] getOutput(ItemStack seed, ItemStack soil, TileEntity tile) {
                ItemStack[] out = (ItemStack[])outputMap.get(soil.func_77960_j());
                if (out == null) {
                    return new ItemStack[0];
                }
                return out;
            }

            @Override
            public boolean isValid(ItemStack seed) {
                return seed.func_77973_b() == AttainedDropsHelper.this.seed;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
                return new IBlockState[0];
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
                return 0.875f;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
                IBlockState state = AttainedDropsHelper.this.plant.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf((double)growth >= 0.5 ? 7 : Math.min(7, Math.round(7.0f * growth * 2.0f))));
                IBakedModel model = blockRenderer.func_184389_a(state);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                blockRenderer.func_175019_b().func_178266_a(model, state, 1.0f, true);
                GlStateManager.func_179121_F();
                if ((double)growth >= 0.5) {
                    state = (IBlockState)bulbMap.get(soil.func_77960_j());
                    model = blockRenderer.func_184389_a(state);
                    if (model == null) {
                        return false;
                    }
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                    float scale = (growth - 0.5f) * 2.0f;
                    GlStateManager.func_179137_b((double)(0.5 - (double)(scale / 2.0f)), (double)1.0, (double)(-0.5 + (double)(scale / 2.0f)));
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    blockRenderer.func_175019_b().func_178266_a(model, state, 1.0f, true);
                    GlStateManager.func_179121_F();
                }
                return true;
            }
        });
    }

    void addTypes() {
        for (ADType type : ADType.values()) {
            outputMap.put(type.ordinal() + 1, (Object)new ItemStack[]{type.getDrop()});
            bulbMap.put(type.ordinal() + 1, (Object)this.bulb.func_176203_a(type.ordinal()));
        }
    }

    @Override
    public void postInit() {
    }

    private static enum ADType {
        BLAZE(new ItemStack(Items.field_151072_bj)),
        PEARL(new ItemStack(Items.field_151079_bi)),
        BONE(new ItemStack(Items.field_151103_aS)),
        SLIME(new ItemStack(Items.field_151123_aH)),
        FLESH(new ItemStack(Items.field_151078_bh)),
        TEAR(new ItemStack(Items.field_151073_bk)),
        GUNPOWDER(new ItemStack(Items.field_151016_H)),
        STRING(new ItemStack(Items.field_151007_F)),
        EYE(new ItemStack(Items.field_151070_bp)),
        PRISMARINE(new ItemStack(Items.field_179562_cC)),
        WITHER(new ItemStack(Items.field_151144_bL, 1, 1)),
        SHULKER(new ItemStack(Items.field_190930_cZ)),
        LEATHER(new ItemStack(Items.field_151116_aA)),
        FEATHER(new ItemStack(Items.field_151008_G)),
        PRISMARINE_C(new ItemStack(Items.field_179563_cD));

        private final ItemStack drop;

        private ADType(ItemStack drop) {
            this.drop = drop;
        }

        public ItemStack getDrop() {
            return this.drop;
        }
    }
}

