/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook;

import com.ferreusveritas.warpbook.WarpBook;
import com.ferreusveritas.warpbook.crafting.WarpBookColorShapeless;
import com.ferreusveritas.warpbook.crafting.WarpPageShapeless;
import com.ferreusveritas.warpbook.item.WarpPageItem;
import com.ferreusveritas.warpbook.item.WarpPotionItem;
import com.ferreusveritas.warpbook.util.JavaUtils;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;

public class Crafting {
    public void register(IForgeRegistry<IRecipe> registry) {
        PotionType awkward = (PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation("awkward"));
        BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)awkward), (ItemStack)new ItemStack(WarpBook.items.warpClusterItem), (ItemStack)new ItemStack((Item)WarpBook.items.unboundWarpPotionItem));
        this.copyPageToUnboundPage(registry, (WarpPageItem)WarpBook.items.locusWarpPageItem);
        this.copyPageToUnboundPage(registry, (WarpPageItem)WarpBook.items.hyperWarpPageItem);
        this.potionToPaper(registry, (WarpPotionItem)WarpBook.items.locusWarpPotionItem, (WarpPageItem)WarpBook.items.locusWarpPageItem);
        this.potionToPaper(registry, (WarpPotionItem)WarpBook.items.playerWarpPotionItem, (WarpPageItem)WarpBook.items.playerWarpPageItem);
        this.potionToPaper(registry, (WarpPotionItem)WarpBook.items.hyperWarpPotionItem, (WarpPageItem)WarpBook.items.hyperWarpPageItem);
        String[] dyeValues = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ItemStack dyedBook = new ItemStack((Item)WarpBook.items.warpBookItem);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("color", this.getColorValue(color));
            dyedBook.func_77982_d(tag);
            registry.register(new WarpBookColorShapeless(dyedBook, (NonNullList<Ingredient>)NonNullList.func_193580_a(null, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)WarpBook.items.warpBookItem)}), new OreIngredient("dye" + dyeValues[color.func_176767_b()])})).setRegistryName("warpbook", "dyeWarpBook_" + color.func_176767_b()));
        }
        ItemStack dyedBook = new ItemStack((Item)WarpBook.items.warpBookItem);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("color", this.getColorValue(EnumDyeColor.MAGENTA));
        dyedBook.func_77982_d(tag);
        registry.register(new WarpBookColorShapeless(new ItemStack((Item)WarpBook.items.warpBookItem), (NonNullList<Ingredient>)NonNullList.func_193580_a(null, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{dyedBook}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151131_as)})})).setRegistryName("warpbook", "dyeWarpBook_X"));
    }

    public int getColorValue(EnumDyeColor from) {
        return (Integer)JavaUtils.getRestrictedObject(EnumDyeColor.class, from, "field_193351_w", "colorValue");
    }

    private void potionToPaper(IForgeRegistry<IRecipe> registry, WarpPotionItem potionIn, WarpPageItem pageOut) {
        if (potionIn.isWarpCloneable(new ItemStack((Item)potionIn))) {
            for (Item paper : new Item[]{Items.field_151121_aF, WarpBook.items.unboundWarpPageItem}) {
                String recipeName = this.upperFirst(pageOut.getRegistryName().func_110623_a()) + "From" + this.upperFirst(potionIn.getRegistryName().func_110623_a()) + "And" + this.upperFirst(paper.getRegistryName().func_110623_a());
                registry.register(new WarpPageShapeless(new ItemStack((Item)pageOut), (NonNullList<Ingredient>)NonNullList.func_193580_a(null, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)potionIn)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(paper)})})).setRegistryName("warpbook", recipeName));
            }
        }
    }

    private void copyPageToUnboundPage(IForgeRegistry<IRecipe> registry, WarpPageItem page) {
        if (page.isWarpCloneable(new ItemStack((Item)page))) {
            String recipeName = this.upperFirst(page.getRegistryName().func_110623_a()) + "FromCopy";
            registry.register(new WarpPageShapeless(new ItemStack((Item)page, 2), (NonNullList<Ingredient>)NonNullList.func_193580_a(null, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)page, 1)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)WarpBook.items.unboundWarpPageItem, 1)})})).setRegistryName("warpbook", recipeName));
        }
    }

    private String upperFirst(String stringIn) {
        return stringIn.substring(0, 1).toUpperCase() + stringIn.substring(1);
    }
}

