/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook.block;

import com.ferreusveritas.warpbook.WarpBook;
import com.ferreusveritas.warpbook.block.IColorableBlock;
import com.ferreusveritas.warpbook.core.WarpColors;
import com.ferreusveritas.warpbook.item.UnboundWarpPotionItem;
import com.ferreusveritas.warpbook.item.WarpItem;
import com.ferreusveritas.warpbook.item.WarpPotionItem;
import com.ferreusveritas.warpbook.tileentity.TileEntityTeleporter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTeleporter
extends Block
implements ITileEntityProvider,
IColorableBlock {
    protected static final AxisAlignedBB TELEPORTER_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockTeleporter() {
        super(Material.field_151573_f);
        this.func_149663_c("teleporter");
        this.setRegistryName("teleporter");
        this.func_149647_a(WarpBook.tabBook);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(10.0f);
        this.func_149752_b(20.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityTeleporter();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            IBlockState newState = state;
            Optional<TileEntityTeleporter> teleporter = this.getTeleportTileEntity((IBlockAccess)world, pos);
            if (teleporter.isPresent()) {
                ItemStack heldItemStack = player.func_184586_b(hand);
                if (player.func_175151_a(pos, facing, heldItemStack)) {
                    Item heldItem = heldItemStack.func_77973_b();
                    if (!heldItemStack.func_190926_b()) {
                        if (heldItem instanceof WarpPotionItem && !(heldItem instanceof UnboundWarpPotionItem)) {
                            teleporter.get().setWarpItem(player.func_184586_b(hand));
                            if (!player.func_184812_l_()) {
                                if (player.func_184586_b(hand).func_190916_E() < 1) {
                                    player.func_184586_b(hand).func_190918_g(1);
                                } else {
                                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                                }
                                player.func_191521_c(new ItemStack(Items.field_151069_bo));
                            }
                        } else if (heldItem == Items.field_151131_as) {
                            teleporter.get().setWarpItem(ItemStack.field_190927_a);
                        } else {
                            return false;
                        }
                    }
                }
                world.func_184138_a(pos, state, newState, 3);
                teleporter.get().func_70296_d();
            }
        }
        return true;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        ItemStack page;
        Optional<TileEntityTeleporter> tile;
        if (entityIn instanceof EntityPlayer && !worldIn.func_175640_z(pos) && (tile = this.getTeleportTileEntity((IBlockAccess)worldIn, pos)).isPresent() && !(page = tile.get().getWarpItem()).func_190926_b()) {
            WarpBook.warpDrive.queueWarp((EntityPlayer)entityIn, page);
        }
    }

    protected Optional<TileEntityTeleporter> getTeleportTileEntity(IBlockAccess access, BlockPos pos) {
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileEntityTeleporter) {
            return Optional.of((TileEntityTeleporter)tile);
        }
        return Optional.empty();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return TELEPORTER_AABB;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess access, BlockPos pos, IBlockState state, int fortune) {
        NBTTagCompound warpTag;
        ItemStack stack = new ItemStack((Block)this, 1, 0);
        NBTTagCompound tag = this.getNBT(stack);
        ItemStack warpItem = this.getWarpItemStack(access, pos);
        if (!warpItem.func_190926_b() && (warpTag = warpItem.serializeNBT()) != null) {
            tag.func_74782_a("warpitem", (NBTBase)warpTag);
            stack.func_77982_d(tag);
        }
        drops.add((Object)stack);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getWarpEncodedItemStack((IBlockAccess)world, pos);
    }

    protected ItemStack getWarpEncodedItemStack(IBlockAccess access, BlockPos pos) {
        NBTTagCompound warpTag;
        ItemStack stack = new ItemStack((Block)this, 1, 0);
        ItemStack warpItem = this.getWarpItemStack(access, pos);
        if (!warpItem.func_190926_b() && (warpTag = warpItem.serializeNBT()) != null) {
            NBTTagCompound tag = this.getNBT(stack);
            tag.func_74782_a("warpitem", (NBTBase)warpTag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public NBTTagCompound getNBT(ItemStack itemStack) {
        return itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Optional<TileEntityTeleporter> tile;
        ItemStack warpStack;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!stack.func_190926_b() && !(warpStack = this.getWarpItemStack(stack)).func_190926_b() && (tile = this.getTeleportTileEntity((IBlockAccess)world, pos)).isPresent()) {
            tile.get().setWarpItem(warpStack);
        }
    }

    public ItemStack getWarpItemStack(IBlockAccess access, BlockPos pos) {
        Optional<TileEntityTeleporter> tile = this.getTeleportTileEntity(access, pos);
        return tile.isPresent() ? tile.get().getWarpItem() : ItemStack.field_190927_a;
    }

    public ItemStack getWarpItemStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            ItemStack warpItemStack;
            NBTTagCompound tag = stack.func_77978_p();
            tag = this.getNBT(stack);
            NBTTagCompound warpTag = tag.func_74775_l("warpitem");
            if (warpTag != null && (warpItemStack = new ItemStack(warpTag)).func_77973_b() instanceof WarpItem) {
                return warpItemStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColor(IBlockState state, IBlockAccess access, BlockPos pos, int tintIndex) {
        Optional<TileEntityTeleporter> tile = this.getTeleportTileEntity(access, pos);
        if (tile.isPresent()) {
            WarpColors wc = tile.get().getWarpColor();
            if (wc == WarpColors.UNBOUND) {
                return -7829368;
            }
            switch (tintIndex) {
                default: {
                    return -1;
                }
                case 0: {
                    return wc.getColor();
                }
                case 1: 
            }
            return wc.getSpecColor();
        }
        return -1;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        Item item;
        super.func_190948_a(stack, world, tooltip, advanced);
        ItemStack warpItemStack = this.getWarpItemStack(stack);
        String destName = "\u00a74\u00a7kUnbound";
        if (!warpItemStack.func_190926_b() && (item = warpItemStack.func_77973_b()) instanceof WarpItem) {
            WarpItem warpItem = (WarpItem)item;
            destName = "\u00a7a" + warpItem.getName(world, warpItemStack);
        }
        tooltip.add(destName);
    }
}

