/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.alloysmelter;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.MachineLevel;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeInput;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class VanillaSmeltingRecipe
implements IMachineRecipe {
    @Nonnull
    private static final VanillaSmeltingRecipe vanillaRecipe = new VanillaSmeltingRecipe();
    @Nonnull
    private static final RecipeLevel RECIPE_LEVEL = RecipeLevel.SIMPLE;
    private static final int RF_PER_ITEM = TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Items.field_151044_h, 1, 0)) * 10 / 8;

    @Nonnull
    public static VanillaSmeltingRecipe getInstance() {
        return vanillaRecipe;
    }

    @SubscribeEvent
    public static void create(EnderIOLifecycleEvent.PostInit.Pre event) {
        MachineRecipeRegistry.instance.registerRecipe(vanillaRecipe);
    }

    private VanillaSmeltingRecipe() {
    }

    @Override
    @Nonnull
    public String getUid() {
        return "VanillaSmeltingRecipe";
    }

    @Override
    public int getEnergyRequired(@Nonnull NNList<MachineRecipeInput> inputs) {
        return this.getNumInputs(inputs) * RF_PER_ITEM;
    }

    @Override
    @Nonnull
    public RecipeBonusType getBonusType(@Nonnull NNList<MachineRecipeInput> inputs) {
        return RecipeBonusType.NONE;
    }

    private int getNumInputs(@Nonnull NNList<MachineRecipeInput> inputs) {
        int numInputs = 0;
        for (MachineRecipeInput input : inputs) {
            if (input == null || !this.isValidInput(MachineLevel.IGNORE, input)) continue;
            numInputs += input.item.func_190916_E();
        }
        return Math.min(numInputs, 3);
    }

    @Override
    public boolean isRecipe(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        if (!machineLevel.canMake(RECIPE_LEVEL)) {
            return false;
        }
        ItemStack output = Prep.getEmpty();
        for (MachineRecipeInput ri : inputs) {
            ItemStack newOutput;
            if (ri == null || !Prep.isValid(ri.item) || !(Prep.isInvalid(output) ? Prep.isInvalid(output = FurnaceRecipes.func_77602_a().func_151395_a(ri.item)) : !(newOutput = FurnaceRecipes.func_77602_a().func_151395_a(ri.item)).func_77969_a(output))) continue;
            return false;
        }
        return Prep.isValid(output);
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] getCompletedResult(long nextSeed, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        ItemStack output = null;
        for (MachineRecipeInput ri : inputs) {
            if (ri == null || !Prep.isValid(ri.item) || output != null) continue;
            output = FurnaceRecipes.func_77602_a().func_151395_a(ri.item);
        }
        if (output == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        int stackSize = output.func_190916_E();
        ItemStack result = output.func_77946_l();
        result.func_190920_e(stackSize * this.getNumInputs(inputs));
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(result)};
    }

    @Override
    public float getExperienceForOutput(@Nonnull ItemStack output) {
        float result = FurnaceRecipes.func_77602_a().func_151398_b(output);
        if (result > 1.0f) {
            result = 1.0f;
        }
        return result * (float)output.func_190916_E();
    }

    @Override
    public boolean isValidInput(@Nonnull RecipeLevel machineLevel, @Nonnull MachineRecipeInput input) {
        return this.isValidInput(machineLevel, input.item);
    }

    public boolean isValidInput(@Nonnull RecipeLevel machineLevel, @Nonnull ItemStack input) {
        if (!machineLevel.canMake(RECIPE_LEVEL)) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(input);
        return Prep.isValid(itemstack);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "alloysmelter";
    }

    @Override
    @Nonnull
    public List<MachineRecipeInput> getQuantitiesConsumed(@Nonnull NNList<MachineRecipeInput> inputs) {
        int consumed = 0;
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>();
        for (MachineRecipeInput ri : inputs) {
            int available;
            int canUse;
            int use;
            if (ri == null || !Prep.isValid(ri.item) || !this.isValidInput(MachineLevel.IGNORE, new MachineRecipeInput(ri.slotNumber, ri.item)) || consumed >= 3 || (use = Math.min(canUse = 3 - consumed, available = ri.item.func_190916_E())) <= 0) continue;
            ItemStack st = ri.item.func_77946_l();
            st.func_190920_e(use);
            result.add(new MachineRecipeInput(ri.slotNumber, st));
            consumed += use;
        }
        return result;
    }

    public List<IRecipe> getAllRecipes() {
        ArrayList<IRecipe> result = new ArrayList<IRecipe>();
        Map metaList = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry entry : metaList.entrySet()) {
            ItemStack output = (ItemStack)entry.getValue();
            int stackSize = output.func_190916_E();
            output.func_190920_e(stackSize);
            ItemStack key = (ItemStack)NullHelper.notnullM(entry.getKey(), (String)"null item stack in furnace recipes");
            result.add(new Recipe(new RecipeInput(key), RF_PER_ITEM, RecipeBonusType.NONE, RECIPE_LEVEL, new RecipeOutput(output)));
        }
        return result;
    }

    @Override
    @Nonnull
    public RecipeLevel getRecipeLevel() {
        return RECIPE_LEVEL;
    }
}

