/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.model;

import com.google.common.collect.Lists;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.render.model.CollectedItemQuadBakedBlockModel;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.base.render.util.ItemQuadCollector;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class FacadeSmartItemModel
implements IBakedModel {
    private final IBakedModel parent;
    @Nonnull
    private final ItemOverrideList overrides = new ItemOverrideList(Lists.newArrayList()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            IBlockState paintSource;
            if (Prep.isInvalid(stack)) {
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            if (!YetaUtil.shouldHeldItemHideFacadesClient() && (paintSource = PaintUtil.getSourceBlock(stack)) != null) {
                ItemQuadCollector quads = new ItemQuadCollector();
                quads.addItemBlockState(paintSource, Prep.getEmpty());
                quads.addBlockState(ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY)), Prep.getEmpty());
                return new CollectedItemQuadBakedBlockModel(originalModel, quads);
            }
            return originalModel;
        }
    };

    public FacadeSmartItemModel(IBakedModel parent) {
        this.parent = parent;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.parent.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        return this.parent.handlePerspective(cameraTransformType);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }
}

