/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.config.config.PersonalConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class ClientUtil {
    public static void regRenderer(@Nonnull Block block, int meta, @Nonnull String name) {
        Item item = Item.func_150898_a((Block)block);
        ResourceLocation resourceLocation = block.getRegistryName();
        if (resourceLocation == null) {
            throw new NullPointerException("Cannot register renderers for block " + block + ": Block is not registered with the block registry");
        }
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourceLocation, name);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    public static void regRenderer(@Nonnull Item item, int meta, @Nonnull String name) {
        ClientUtil.regRenderer(item, meta, new ResourceLocation("enderio", name));
    }

    public static void regRenderer(@Nonnull Item item, int meta, @Nonnull ResourceLocation loc) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
    }

    public static void registerDefaultItemRenderer(@Nonnull IModObject mo) {
        Item item = mo.getItem();
        if (item != null) {
            ClientUtil.regRenderer(item, 0, mo.getUnlocalisedName());
        }
    }

    public static void registerRenderer(@Nonnull Item item, @Nonnull String name) {
        ClientUtil.regRenderer(item, 0, name);
    }

    public static void spawnParcticles(double posX, double posY, double posZ, int count, @Nonnull EnumParticleTypes particle) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (!((Boolean)PersonalConfig.machineParticlesEnabled.get()).booleanValue() || NullHelper.untrust((Object)world) == null) {
            return;
        }
        Random rand = world.field_73012_v;
        for (int i = 0; i < count; ++i) {
            double d2;
            double d1;
            double d0;
            double zOff;
            double yOff;
            double xOff;
            if (particle == EnumParticleTypes.PORTAL) {
                xOff = (rand.nextDouble() - 0.5) * 1.1;
                yOff = (rand.nextDouble() - 0.5) * 1.1;
                zOff = (rand.nextDouble() - 0.5) * 1.1;
                d0 = (rand.nextDouble() - 0.5) * 1.5;
                d1 = -rand.nextDouble();
                d2 = (rand.nextDouble() - 0.5) * 1.5;
            } else if (particle == EnumParticleTypes.DAMAGE_INDICATOR) {
                xOff = 0.1;
                yOff = 0.0;
                zOff = 0.1;
                d2 = 0.2;
                d1 = 0.2;
                d0 = 0.2;
            } else {
                zOff = 0.0;
                yOff = 0.0;
                xOff = 0.0;
                d0 = rand.nextGaussian() * 0.02;
                d1 = rand.nextGaussian() * 0.02;
                d2 = rand.nextGaussian() * 0.02;
            }
            world.func_175688_a(particle, posX + xOff, posY + yOff, posZ + zOff, d0, d1, d2, new int[0]);
        }
    }
}

