/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.moons.koentus.world.gen;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.moons.koentus.world.gen.feature.WorldGenGravityHarvester;
import stevekung.mods.moreplanets.planets.diona.world.gen.BiomeDecoratorDiona;
import stevekung.mods.moreplanets.planets.diona.world.gen.feature.WorldGenCrashedAlienProbe;
import stevekung.mods.moreplanets.planets.diona.world.gen.structure.MapGenCrashedAlienShipFeature;
import stevekung.mods.moreplanets.utils.world.gen.ChunkGeneratorBaseMP;
import stevekung.mods.moreplanets.utils.world.gen.feature.WorldGenSpaceDungeons;
import stevekung.mods.stevekunglib.world.gen.MapGenCavesBase;

public class ChunkGeneratorKoentus
extends ChunkGeneratorBaseMP {
    private final BiomeDecoratorDiona decorator = new BiomeDecoratorDiona();
    private final MapGenCavesBase caveGenerator = new MapGenCavesBase(MPBlocks.KOENTUS_REGOLITH.func_176223_P(), Blocks.field_150353_l.func_176223_P(), (Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.KOENTUS_FINE_REGOLITH, MPBlocks.KOENTUS_ROCK}));
    private final MapGenCrashedAlienShipFeature alienShipFeatureGenerator = new MapGenCrashedAlienShipFeature();

    public ChunkGeneratorKoentus(World world, long seed) {
        super(world, seed);
    }

    @Override
    protected void preGenerateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
        this.createCraters(chunkX, chunkZ, primer);
    }

    @Override
    protected void generateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
        this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.alienShipFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
    }

    @Override
    protected void populate(BlockPos pos, ChunkPos chunkpos, Biome biome, int chunkX, int chunkZ, int x, int z) {
        this.decorator.func_180292_a(this.world, this.rand, biome, pos);
        this.alienShipFeatureGenerator.func_175794_a(this.world, this.rand, chunkpos);
        if (this.rand.nextInt(50) == 0) {
            int posY = this.world.func_175672_r(pos.func_177982_a(0, 0, 0)).func_177956_o();
            new WorldGenGravityHarvester().func_180709_b(this.world, this.rand, pos.func_177982_a(0, posY + 2 + this.rand.nextInt(3), 0));
        }
        for (int i = 0; i < 8; ++i) {
            new WorldGenSpaceDungeons(MPBlocks.DIONA_ANCIENT_CHEST.func_176223_P(), MPBlocks.KOENTUS_COBBLESTONE.func_176223_P(), MPBlocks.ALBETIUS_WORM_EGG_ROCK.func_176223_P()).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(250) == 0) {
            int posX = this.rand.nextInt(16) + 8;
            int posZ = this.rand.nextInt(16) + 8;
            int posY = this.world.func_175672_r(pos.func_177982_a(posX, 0, posZ)).func_177956_o();
            new WorldGenCrashedAlienProbe().func_180709_b(this.world, this.rand, pos.func_177982_a(posX, posY, posZ));
        }
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        this.alienShipFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
    }

    public boolean func_193414_a(World world, String name, BlockPos pos) {
        return "AlienShip".equals(name) && this.alienShipFeatureGenerator != null ? this.alienShipFeatureGenerator.func_175795_b(pos) : false;
    }

    @Nullable
    public BlockPos func_180513_a(World world, String name, BlockPos pos, boolean findUnexplored) {
        return "AlienShip".equals(name) && this.alienShipFeatureGenerator != null ? this.alienShipFeatureGenerator.func_180706_b(world, pos, findUnexplored) : null;
    }

    @Override
    protected IBlockState getTopBlock() {
        return MPBlocks.KOENTUS_REGOLITH.func_176223_P();
    }

    @Override
    protected IBlockState getSubBlock() {
        return MPBlocks.KOENTUS_FINE_REGOLITH.func_176223_P();
    }

    @Override
    protected IBlockState getStoneBlock() {
        return MPBlocks.KOENTUS_ROCK.func_176223_P();
    }
}

