/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.utils.blocks.BlockBushMP;
import stevekung.mods.stevekunglib.utils.BlockStateProperty;
import stevekung.mods.stevekunglib.utils.BlockUtils;

public class BlockInfectedSugarCane
extends BlockBushMP {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockInfectedSugarCane(String name) {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStateProperty.AGE_15, (Comparable)Integer.valueOf(0)));
        this.func_149663_c(name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((world.func_180495_p(pos.func_177977_b()).func_177230_c() == MPBlocks.INFECTED_SUGAR_CANE || this.canBlockStay(world, pos, state)) && world.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.func_177229_b((IProperty)BlockStateProperty.AGE_15);
                if (j == 15) {
                    world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                    world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateProperty.AGE_15, (Comparable)Integer.valueOf(0)), 4);
                } else {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateProperty.AGE_15, (Comparable)Integer.valueOf(j + 1)), 4);
                }
            }
        }
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (BlockUtils.isFluid((World)world, (BlockPos)pos)) {
            return false;
        }
        if (block == this) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            if (block != MPBlocks.INFECTED_GRASS_BLOCK && block != MPBlocks.INFECTED_DIRT && block != MPBlocks.INFECTED_COARSE_DIRT && block != MPBlocks.INFECTED_SAND || world.func_180495_p(pos.func_177972_a(facing).func_177977_b()).func_177230_c() != MPBlocks.INFECTED_WATER_FLUID_BLOCK) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return this.func_176196_c(world, pos);
    }

    @Override
    protected boolean validBlock(Block block) {
        return block == this || block == MPBlocks.INFECTED_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.INFECTED_SAND;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return MPItems.INFECTED_SUGAR_CANE;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(MPItems.INFECTED_SUGAR_CANE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.AGE_15, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockStateProperty.AGE_15);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateProperty.AGE_15});
    }
}

