/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.world.gen.dungeon;

import java.lang.reflect.Constructor;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.dungeon.DungeonStartNibiru;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.dungeon.PieceNibiru;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.dungeon.RoomBossNibiru;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.dungeon.RoomChestNibiru;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.dungeon.RoomEmptyNibiru;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.dungeon.RoomSpawnerNibiru;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.dungeon.SizedPieceNibiru;
import stevekung.mods.moreplanets.utils.world.gen.dungeon.DungeonConfigurationMP;

public class CorridorNibiru
extends SizedPieceNibiru {
    public CorridorNibiru() {
    }

    public CorridorNibiru(DungeonConfigurationMP configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing direction) {
        super(configuration, sizeX, sizeY, sizeZ, direction);
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(blockPosX, configuration.getYPosition(), blockPosZ, blockPosX + sizeX, configuration.getYPosition() + sizeY, blockPosZ + sizeZ);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        for (int i = 0; i < this.field_74887_e.func_78883_b(); ++i) {
            for (int j = 0; j < this.field_74887_e.func_78882_c(); ++j) {
                for (int k = 0; k < this.field_74887_e.func_78880_d(); ++k) {
                    if (j == 2 && this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (k + 1) % 1 == 0 && k != this.field_74887_e.func_78880_d() - 1) {
                        if (i == 0 || i == this.field_74887_e.func_78883_b() - 1) {
                            this.func_175811_a(worldIn, MPBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P(), i, j, k + 1, this.field_74887_e);
                            continue;
                        }
                        if (i == 1 || i == this.field_74887_e.func_78883_b() - 2) {
                            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), i, j, k + 1, this.field_74887_e);
                            continue;
                        }
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (j == 2 && this.getDirection().func_176740_k() == EnumFacing.Axis.X && (i + 1) % 1 == 0 && i != this.field_74887_e.func_78883_b() - 1) {
                        if (k == 0 || k == this.field_74887_e.func_78880_d() - 1) {
                            this.func_175811_a(worldIn, MPBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P(), i + 1, j, k, this.field_74887_e);
                            continue;
                        }
                        if (k == 1 || k == this.field_74887_e.func_78880_d() - 2) {
                            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), i + 1, j, k, this.field_74887_e);
                            continue;
                        }
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (i == 1 || i == this.field_74887_e.func_78883_b() - 2) || j == 0 || j == this.field_74887_e.func_78882_c() - 1 || this.getDirection().func_176740_k() == EnumFacing.Axis.X && (k == 1 || k == this.field_74887_e.func_78880_d() - 2)) {
                        this.func_175811_a(worldIn, j == 0 || j == this.field_74887_e.func_78882_c() - 1 ? MPBlocks.MOSSY_NIBIRU_DUNGEON_BRICK.func_176223_P() : this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (i == 0 || i == this.field_74887_e.func_78883_b() - 1) || this.getDirection().func_176740_k() == EnumFacing.Axis.X && (k == 0 || k == this.field_74887_e.func_78880_d() - 1)) {
                        this.func_175811_a(worldIn, j == 0 || j == this.field_74887_e.func_78882_c() - 1 ? MPBlocks.MOSSY_NIBIRU_DUNGEON_BRICK.func_176223_P() : this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                }
            }
        }
        return true;
    }

    @Override
    public PieceNibiru getNextPiece(DungeonStartNibiru startPiece, Random rand) {
        int pieceCount = startPiece.attachedComponents.size();
        if (pieceCount > 10 && startPiece.attachedComponents.get(pieceCount - 2) instanceof RoomBossNibiru) {
            try {
                return this.getRoom(this.configuration.getTreasureRoom(), startPiece, rand);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PieceNibiru lastPiece;
            boolean bossRoom;
            int bossRoomChance = Math.max((int)(20.0 / (double)(pieceCount - 10)), 1);
            boolean bl = bossRoom = pieceCount > 25 || pieceCount > 10 && rand.nextInt(bossRoomChance) == 0;
            if (bossRoom) {
                try {
                    return this.getRoom(this.configuration.getBossRoom(), startPiece, rand);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            StructureBoundingBox extension = this.getExtension(this.getDirection(), rand.nextInt(4) + 6, rand.nextInt(4) + 6);
            if (startPiece.checkIntersection(extension)) {
                return null;
            }
            int sizeX = extension.field_78893_d - extension.field_78897_a;
            int sizeZ = extension.field_78892_f - extension.field_78896_c;
            int sizeY = this.configuration.getRoomHeight();
            int blockX = extension.field_78897_a;
            int blockZ = extension.field_78896_c;
            if (Math.abs(startPiece.func_74874_b().field_78892_f - this.field_74887_e.field_78896_c) > 200) {
                return null;
            }
            if (Math.abs(startPiece.func_74874_b().field_78893_d - this.field_74887_e.field_78897_a) > 200) {
                return null;
            }
            PieceNibiru pieceNibiru = lastPiece = startPiece.attachedComponents.size() <= 2 ? null : (PieceNibiru)startPiece.attachedComponents.get(startPiece.attachedComponents.size() - 2);
            if (!(lastPiece instanceof RoomSpawnerNibiru)) {
                return new RoomSpawnerNibiru(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
            }
            if (rand.nextInt(2) == 0) {
                return new RoomEmptyNibiru(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
            }
            return new RoomChestNibiru(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
        }
        return null;
    }

    private <T extends SizedPieceNibiru> T getRoom(Class<?> clazz, DungeonStartNibiru startPiece, Random rand) {
        try {
            Constructor<?> c0 = clazz.getConstructor(DungeonConfigurationMP.class, Random.class, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            SizedPieceNibiru dummy = (SizedPieceNibiru)((Object)c0.newInstance(this.configuration, rand, 0, 0, this.getDirection().func_176734_d()));
            StructureBoundingBox extension = this.getExtension(this.getDirection(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeX() : dummy.getSizeZ(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeZ() : dummy.getSizeX());
            if (startPiece.checkIntersection(extension)) {
                return null;
            }
            int sizeX = extension.field_78893_d - extension.field_78897_a;
            int sizeZ = extension.field_78892_f - extension.field_78896_c;
            int sizeY = dummy.getSizeY();
            int blockX = extension.field_78897_a;
            int blockZ = extension.field_78896_c;
            Constructor<?> c1 = clazz.getConstructor(DungeonConfigurationMP.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            return (T)((Object)((SizedPieceNibiru)((Object)c1.newInstance(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d()))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

