/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import javax.annotation.Nonnull;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.Mekanism;
import mekanism.common.base.ISustainedData;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;

public class InfuseStorage
implements ISustainedData {
    private InfuseType type;
    private int amount;

    public InfuseStorage() {
    }

    public InfuseStorage(InfuseType infuseType, int infuseAmount) {
        this.type = infuseType;
        this.amount = infuseAmount;
    }

    public void copyFrom(@Nonnull InfuseStorage other) {
        this.type = other.getType();
        this.amount = other.getAmount();
    }

    public boolean contains(InfuseStorage storage) {
        return this.type == storage.type && this.amount >= storage.amount;
    }

    public void subtract(InfuseStorage storage) {
        if (this.contains(storage)) {
            this.amount -= storage.amount;
        } else if (this.type == storage.type) {
            this.amount = 0;
        }
        if (this.amount <= 0) {
            this.type = null;
            this.amount = 0;
        }
    }

    public void increase(InfuseStorage input) {
        if (this.type == null) {
            this.type = input.type;
            this.amount = input.amount;
        } else if (this.type == input.type) {
            this.amount += input.amount;
        } else {
            Mekanism.logger.error("Tried to increase infusion storage with an incompatible type", (Throwable)new Exception());
        }
    }

    public void increase(InfuseObject input) {
        if (this.type == null) {
            this.type = input.type;
            this.amount = input.stored;
        } else if (this.type == input.type) {
            this.amount += input.stored;
        } else {
            Mekanism.logger.error("Tried to increase infusion storage with an incompatible type", (Throwable)new Exception());
        }
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.type != null && this.amount > 0) {
            ItemDataUtils.setString(itemStack, "infuseType", this.type.name);
            ItemDataUtils.setInt(itemStack, "infuseAmount", this.amount);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "infuseType") && ItemDataUtils.hasData(itemStack, "infuseAmount")) {
            this.type = InfuseRegistry.get(ItemDataUtils.getString(itemStack, "infuseType"));
            if (this.type != null) {
                this.amount = ItemDataUtils.getInt(itemStack, "infuseAmount");
            }
        } else {
            this.type = null;
            this.amount = 0;
        }
    }

    public InfuseType getType() {
        return this.amount == 0 ? null : this.type;
    }

    public InfuseStorage setType(InfuseType type) {
        this.type = type;
        return this;
    }

    public int getAmount() {
        return this.type == null ? 0 : this.amount;
    }

    public InfuseStorage setAmount(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount must be positive");
        }
        this.amount = amount;
        return this;
    }

    public void setEmpty() {
        this.amount = 0;
        this.type = null;
    }
}

