/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import javax.annotation.Nonnull;
import mcmultipart.api.multipart.IMultipart;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.integration.multipart.MultipartMekanism;
import mekanism.common.item.ItemBlockMultipartAble;
import mekanism.common.tile.TileEntityGlowPanel;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class ItemBlockGlowPanel
extends ItemBlockMultipartAble {
    public Block metaBlock;

    public ItemBlockGlowPanel(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public int func_77647_b(int i) {
        return i;
    }

    @Override
    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState state) {
        if (stack.func_77952_i() >= EnumColor.DYES.length) {
            return false;
        }
        boolean place = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state);
        if (place) {
            TileEntityGlowPanel tileEntity = (TileEntityGlowPanel)world.func_175625_s(pos);
            EnumColor col = EnumColor.DYES[stack.func_77952_i()];
            BlockPos pos1 = pos.func_177972_a(side.func_176734_d());
            if (world.isSideSolid(pos1, side)) {
                tileEntity.setOrientation(side.func_176734_d());
            }
            tileEntity.setColour(col);
            if (!world.field_72995_K) {
                Mekanism.packetHandler.sendUpdatePacket(tileEntity);
            }
        }
        return place;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> listToAddTo) {
        if (this.func_194125_a(tab)) {
            for (EnumColor color : EnumColor.DYES) {
                listToAddTo.add((Object)new ItemStack((Item)this, 1, color.getMetaValue()));
            }
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        int itemDamage = stack.func_77952_i();
        if (itemDamage >= EnumColor.DYES.length) {
            return "Invalid Damage: " + itemDamage;
        }
        EnumColor colour = EnumColor.DYES[itemDamage];
        if (LangUtils.canLocalize(this.func_77667_c(stack) + "." + colour.dyeName)) {
            return LangUtils.localize(this.func_77667_c(stack) + "." + colour.dyeName);
        }
        String colourName = colour == EnumColor.BLACK ? (Object)((Object)EnumColor.DARK_GREY) + colour.getDyeName() : colour.getDyedName();
        return colourName + " " + super.func_77653_i(stack);
    }

    public boolean func_77629_n_() {
        return true;
    }

    @Override
    @Optional.Method(modid="mcmultipart")
    protected IMultipart getMultiPart() {
        return MultipartMekanism.GLOWPANEL_MP;
    }
}

