/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch.platform;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.extensibility.MixinContextQuery;

public final class GlobalMixinContextQuery {
    public static final String MIXIN_LOCATION_DECORATOR = "mixinLocation";
    public static final String MIXIN_OWNER_DECORATOR = "mixinOwner";
    public static final String UNKNOWN_LOCATION = "unknown-location";
    public static final String UNKNOWN_OWNER = "unknown-owner";
    private static boolean init = false;
    private final List<MixinContextQuery> queries = new ArrayList<MixinContextQuery>();

    public static void init() {
        if (!init) {
            GlobalProperties.put(GlobalProperties.Keys.CLEANROOM_GLOBAL_MIXIN_CONTEXT_QUERY, (Object)new GlobalMixinContextQuery());
            init = true;
        }
    }

    public static String location(IMixinInfo info) {
        return GlobalMixinContextQuery.location(info.getConfig(), UNKNOWN_LOCATION);
    }

    public static String location(IMixinInfo info, String defaultValue) {
        return GlobalMixinContextQuery.location(info.getConfig(), defaultValue);
    }

    public static String location(IMixinConfig config) {
        return GlobalMixinContextQuery.location(config, UNKNOWN_LOCATION);
    }

    public static String location(IMixinConfig config, String defaultValue) {
        GlobalMixinContextQuery.init();
        return ((GlobalMixinContextQuery)GlobalProperties.get(GlobalProperties.Keys.CLEANROOM_GLOBAL_MIXIN_CONTEXT_QUERY)).getLocation(config, defaultValue);
    }

    public static String owner(IMixinInfo info) {
        return GlobalMixinContextQuery.location(info.getConfig(), UNKNOWN_OWNER);
    }

    public static String owner(IMixinInfo info, String defaultValue) {
        return GlobalMixinContextQuery.location(info.getConfig(), defaultValue);
    }

    public static String owner(IMixinConfig config) {
        return GlobalMixinContextQuery.location(config, UNKNOWN_OWNER);
    }

    public static String owner(IMixinConfig config, String defaultValue) {
        GlobalMixinContextQuery.init();
        return ((GlobalMixinContextQuery)GlobalProperties.get(GlobalProperties.Keys.CLEANROOM_GLOBAL_MIXIN_CONTEXT_QUERY)).getOwner(config, defaultValue);
    }

    private GlobalMixinContextQuery() {
    }

    public void add(MixinContextQuery query) {
        this.queries.add(query);
    }

    public String getLocation(IMixinConfig config) {
        return this.getLocation(config, UNKNOWN_LOCATION);
    }

    public String getLocation(IMixinConfig config, String defaultValue) {
        String value = (String)config.getDecoration(MIXIN_LOCATION_DECORATOR);
        if (value != null) {
            return "".equals(value) ? defaultValue : value;
        }
        List<MixinContextQuery> queries = this.queries;
        for (int i = 0; i < queries.size() && (value = queries.get(i).getLocation(config)) == null; ++i) {
        }
        config.decorate(MIXIN_LOCATION_DECORATOR, value == null ? "" : value);
        return value == null ? defaultValue : value;
    }

    public String getOwner(IMixinConfig config) {
        return this.getLocation(config, UNKNOWN_OWNER);
    }

    public String getOwner(IMixinConfig config, String defaultValue) {
        String value = (String)config.getDecoration(MIXIN_OWNER_DECORATOR);
        if (value != null) {
            return "".equals(value) ? defaultValue : value;
        }
        List<MixinContextQuery> queries = this.queries;
        for (int i = 0; i < queries.size() && (value = queries.get(i).getOwner(config)) == null; ++i) {
        }
        config.decorate(MIXIN_OWNER_DECORATOR, value == null ? "" : value);
        return value == null ? defaultValue : value;
    }
}

