/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.item.IArmorGravity;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.IWeatherProvider;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockGrating;
import micdoodle8.mods.galacticraft.core.client.BubbleRenderer;
import micdoodle8.mods.galacticraft.core.client.FootprintRenderer;
import micdoodle8.mods.galacticraft.core.client.SkyProviderOverworld;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.player.EnumGravity;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class TransformerHooks {
    private static List<IWorldGenerator> otherModGeneratorsWhitelist = new LinkedList<IWorldGenerator>();
    private static IWorldGenerator generatorTCAuraNodes = null;
    private static Method generateTCAuraNodes = null;
    private static boolean generatorsInitialised = false;
    public static List<Block> spawnListAE2_GC = new LinkedList<Block>();
    public static ThreadLocal<BufferBuilder> renderBuilder = new ThreadLocal();
    private static int rainSoundCounter = 0;
    private static Random random = new Random();

    public static double getGravityForEntity(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            if (entity instanceof EntityChicken && !OxygenUtil.isAABBInBreathableAirBlock(entity.field_70170_p, entity.func_174813_aQ())) {
                return 0.08;
            }
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)entity.field_70170_p.field_73011_w;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71071_by != null) {
                    int armorModLowGrav = 100;
                    int armorModHighGrav = 100;
                    for (ItemStack armorPiece : player.func_184193_aE()) {
                        if (armorPiece == null || !(armorPiece.func_77973_b() instanceof IArmorGravity)) continue;
                        armorModLowGrav -= ((IArmorGravity)armorPiece.func_77973_b()).gravityOverrideIfLow(player);
                        armorModHighGrav -= ((IArmorGravity)armorPiece.func_77973_b()).gravityOverrideIfHigh(player);
                    }
                    if (armorModLowGrav > 100) {
                        armorModLowGrav = 100;
                    }
                    if (armorModHighGrav > 100) {
                        armorModHighGrav = 100;
                    }
                    if (armorModLowGrav < 0) {
                        armorModLowGrav = 0;
                    }
                    if (armorModHighGrav < 0) {
                        armorModHighGrav = 0;
                    }
                    if (customProvider.getGravity() > 0.0f) {
                        return 0.08 - (double)(customProvider.getGravity() * (float)armorModLowGrav / 100.0f);
                    }
                    return 0.08 - (double)(customProvider.getGravity() * (float)armorModHighGrav / 100.0f);
                }
            }
            return 0.08 - (double)customProvider.getGravity();
        }
        if (entity instanceof IAntiGrav) {
            return 0.0;
        }
        return 0.08;
    }

    public static double getItemGravity(EntityItem e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)e.field_70170_p.field_73011_w;
            return Math.max(0.002, (double)0.04f - (customProvider instanceof IOrbitDimension ? 0.05999999910593033 : (double)customProvider.getGravity()) / 1.75);
        }
        return 0.04f;
    }

    public static float getArrowGravity(EntityArrow e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            return ((IGalacticraftWorldProvider)e.field_70170_p.field_73011_w).getArrowGravity();
        }
        return 0.05f;
    }

    public static float getRainStrength(World world, float partialTicks) {
        if (world.field_72995_K && world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld) {
            return 0.0f;
        }
        return world.field_73003_n + (world.field_73004_o - world.field_73003_n) * partialTicks;
    }

    public static void otherModGenerate(int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w instanceof WorldProviderSpaceStation) {
            return;
        }
        if (!(world.field_73011_w instanceof IGalacticraftWorldProvider) || ConfigManagerCore.enableOtherModsFeatures) {
            try {
                GameRegistry.generateWorld((int)chunkX, (int)chunkZ, (World)world, (IChunkGenerator)chunkGenerator, (IChunkProvider)chunkProvider);
            }
            catch (Exception e) {
                GalacticraftCore.logger.error("Error in another mod's worldgen.  This is *NOT* a Galacticraft bug, report it to the other mod please.", new Object[0]);
                GalacticraftCore.logger.error("Details:- Dimension:" + GCCoreUtil.getDimensionID(world) + "  Chunk cx,cz:" + chunkX + "," + chunkZ + "  Seed:" + world.func_72905_C(), new Object[0]);
                e.printStackTrace();
            }
            return;
        }
        if (!generatorsInitialised) {
            generatorsInitialised = true;
            if (ConfigManagerCore.whitelistCoFHCoreGen) {
                TransformerHooks.addWorldGenForName("CoFHCore custom oregen", "cofh.cofhworld.init.WorldHandler");
            }
            TransformerHooks.addWorldGenForName("GalacticGreg oregen", "bloodasp.galacticgreg.GT_Worldgenerator_Space");
            TransformerHooks.addWorldGenForName("Dense Ores oregen", "com.rwtema.denseores.WorldGenOres");
            TransformerHooks.addWorldGenForName("AE2 meteorites worldgen", "appeng.worldgen.MeteoriteWorldGen");
            try {
                Class<?> genThaumCraft = Class.forName("thaumcraft.common.lib.world.ThaumcraftWorldGenerator");
                if (genThaumCraft != null && ConfigManagerCore.enableThaumCraftNodes) {
                    Field regField = GameRegistry.class.getDeclaredField("worldGenerators");
                    regField.setAccessible(true);
                    Set registeredGenerators = (Set)regField.get(null);
                    for (IWorldGenerator gen : registeredGenerators) {
                        if (!genThaumCraft.isInstance(gen)) continue;
                        generatorTCAuraNodes = gen;
                        break;
                    }
                    if (generatorTCAuraNodes != null) {
                        generateTCAuraNodes = genThaumCraft.getDeclaredMethod("generateWildNodes", World.class, Random.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                        generateTCAuraNodes.setAccessible(true);
                        GalacticraftCore.logger.info("Whitelisting ThaumCraft aura node generation on planets.", new Object[0]);
                    }
                }
            }
            catch (Exception genThaumCraft) {
                // empty catch block
            }
        }
        if (otherModGeneratorsWhitelist.size() > 0 || generateTCAuraNodes != null) {
            try {
                long worldSeed = world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
                fmlRandom.setSeed(chunkSeed);
                for (IWorldGenerator gen : otherModGeneratorsWhitelist) {
                    gen.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generateTCAuraNodes != null) {
                    generateTCAuraNodes.invoke((Object)generatorTCAuraNodes, world, fmlRandom, chunkX, chunkZ, false, true);
                }
            }
            catch (Exception e) {
                GalacticraftCore.logger.error("Error in another mod's worldgen.  This is *NOT* a Galacticraft bug, report it to the other mod please.", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    private static void addWorldGenForName(String logString, String name) {
        try {
            Class<?> target = Class.forName(name);
            if (target != null) {
                Field regField = GameRegistry.class.getDeclaredField("worldGenerators");
                regField.setAccessible(true);
                Set registeredGenerators = (Set)regField.get(null);
                for (IWorldGenerator gen : registeredGenerators) {
                    if (!target.isInstance(gen)) continue;
                    otherModGeneratorsWhitelist.add(gen);
                    GalacticraftCore.logger.info("Whitelisting " + logString + " on planets.", new Object[0]);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean addAE2MeteorSpawn(Object o, Block b) {
        if (o instanceof Collection) {
            ((Collection)o).add(b);
            ((Collection)o).addAll(spawnListAE2_GC);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getWorldBrightness(World world) {
        if (world.field_73011_w instanceof WorldProviderMoon) {
            float f1 = world.func_72826_c(1.0f);
            float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.2f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            f2 = 1.0f - f2;
            return f2 * 0.8f;
        }
        return world.func_72971_b(1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static float getColorRed(World world) {
        return (float)WorldUtil.getWorldColor((World)world).x;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getColorGreen(World world) {
        return (float)WorldUtil.getWorldColor((World)world).y;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getColorBlue(World world) {
        return (float)WorldUtil.getWorldColor((World)world).z;
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec3d getFogColorHook(World world) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld) {
            float var20 = ((float)player.field_70163_u - 200.0f) / 1000.0f;
            var20 = MathHelper.func_76129_c((float)var20);
            float var21 = Math.max(1.0f - var20 * 40.0f, 0.0f);
            Vec3d vec = world.func_72948_g(1.0f);
            return new Vec3d(vec.field_72450_a * (double)Math.max(1.0f - var20 * 1.29f, 0.0f), vec.field_72448_b * (double)Math.max(1.0f - var20 * 1.29f, 0.0f), vec.field_72449_c * (double)Math.max(1.0f - var20 * 1.29f, 0.0f));
        }
        return world.func_72948_g(1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec3d getSkyColorHook(World world) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld || player != null && player.field_70163_u > 130.0 && player.func_184187_bx() instanceof EntitySpaceshipBase) {
            float f1 = world.func_72826_c(1.0f);
            float f2 = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.5f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            int i = MathHelper.func_76128_c((double)player.field_70165_t);
            int j = MathHelper.func_76128_c((double)player.field_70163_u);
            int k = MathHelper.func_76128_c((double)player.field_70161_v);
            BlockPos pos = new BlockPos(i, j, k);
            int l = ForgeHooksClient.getSkyBlendColour((World)world, (BlockPos)pos);
            float f4 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f5 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f6 = (float)(l & 0xFF) / 255.0f;
            f4 *= f2;
            f5 *= f2;
            f6 *= f2;
            if (player.field_70163_u <= 200.0) {
                Vec3d vec = world.func_72833_a(FMLClientHandler.instance().getClient().func_175606_aa(), 1.0f);
                double blend = (player.field_70163_u - 130.0) / 70.0;
                double ablend = 1.0 - blend;
                return new Vec3d((double)f4 * blend + vec.field_72450_a * ablend, (double)f5 * blend + vec.field_72448_b * ablend, (double)f6 * blend + vec.field_72449_c * ablend);
            }
            double blend = Math.min(1.0, (player.field_70163_u - 200.0) / 300.0);
            double ablend = 1.0 - blend;
            return new Vec3d((double)f4 * ablend + (blend /= 255.0) * 31.0, (double)f5 * ablend + blend * 8.0, (double)f6 * ablend + blend * 99.0);
        }
        return world.func_72833_a(FMLClientHandler.instance().getClient().func_175606_aa(), 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static double getRenderPosY(Entity viewEntity, double regular) {
        if (viewEntity.field_70163_u >= 256.0) {
            return 255.0;
        }
        return regular + (double)viewEntity.func_70047_e();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean shouldRenderFire(Entity entity) {
        if (entity.field_70170_p == null || !(entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider)) {
            return entity.func_70027_ad();
        }
        if (!(entity instanceof EntityLivingBase) && !(entity instanceof EntityArrow)) {
            return entity.func_70027_ad();
        }
        if (entity.func_70027_ad()) {
            if (OxygenUtil.noAtmosphericCombustion(entity.field_70170_p.field_73011_w)) {
                return OxygenUtil.isAABBInBreathableAirBlock(entity.field_70170_p, entity.func_174813_aQ());
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void orientCamera(float partialTicks) {
        Entity entity;
        float offset;
        EntityPlayerSP player = ClientProxyCore.mc.field_71439_g;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        Entity viewEntity = ClientProxyCore.mc.func_175606_aa();
        if (player.func_184187_bx() instanceof ICameraZoomEntity && ClientProxyCore.mc.field_71474_y.field_74320_O == 0 && (offset = ((ICameraZoomEntity)(entity = player.func_184187_bx())).getRotateOffset()) > -10.0f) {
            GL11.glTranslatef((float)0.0f, (float)(-(offset += ClientProxyCore.PLAYER_Y_OFFSET)), (float)0.0f);
            float anglePitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            float angleYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
            GL11.glRotatef((float)(-anglePitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)angleYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)offset, (float)0.0f);
        }
        if (viewEntity instanceof EntityLivingBase && viewEntity.field_70170_p.field_73011_w instanceof IZeroGDimension && !((EntityLivingBase)viewEntity).func_70608_bn()) {
            float pitch = viewEntity.field_70127_C + (viewEntity.field_70125_A - viewEntity.field_70127_C) * partialTicks;
            float yaw = viewEntity.field_70126_B + (viewEntity.field_70177_z - viewEntity.field_70126_B) * partialTicks + 180.0f;
            float eyeHeightChange = viewEntity.field_70130_N / 2.0f;
            GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-pitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.1f);
            EnumGravity gDir = stats.getGdir();
            GL11.glRotatef((float)(180.0f * gDir.getThetaX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(180.0f * gDir.getThetaZ()), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(pitch * gDir.getPitchGravityX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(pitch * gDir.getPitchGravityY()), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(yaw * gDir.getYawGravityX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(yaw * gDir.getYawGravityY()), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(yaw * gDir.getYawGravityZ()), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(eyeHeightChange * gDir.getEyeVecX()), (float)(eyeHeightChange * gDir.getEyeVecY()), (float)(eyeHeightChange * gDir.getEyeVecZ()));
            if (stats.getGravityTurnRate() < 1.0f) {
                GL11.glRotatef((float)(90.0f * (stats.getGravityTurnRatePrev() + (stats.getGravityTurnRate() - stats.getGravityTurnRatePrev()) * partialTicks)), (float)stats.getGravityTurnVecX(), (float)stats.getGravityTurnVecY(), (float)stats.getGravityTurnVecZ());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderLiquidOverlays(float partialTicks) {
        boolean within = false;
        for (Map.Entry<Fluid, ResourceLocation> entry : ClientProxyCore.submergedTextures.entrySet()) {
            if (!FluidUtil.isInsideOfFluid((Entity)ClientProxyCore.mc.field_71439_g, entry.getKey())) continue;
            within = true;
            ClientProxyCore.mc.func_110434_K().func_110577_a(entry.getValue());
            break;
        }
        if (!within) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        float f1 = ClientProxyCore.mc.field_71439_g.func_70013_c() / 3.0f;
        GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        float f2 = 4.0f;
        float f3 = -1.1f;
        float f4 = 1.1f;
        float f5 = -1.1f;
        float f6 = 1.1f;
        float f7 = -0.25f;
        float f8 = -ClientProxyCore.mc.field_71439_g.field_70177_z / 64.0f;
        float f9 = ClientProxyCore.mc.field_71439_g.field_70125_A / 64.0f;
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)f3, (double)f5, (double)f7).func_187315_a((double)(f2 + f8), (double)(f2 + f9)).func_181675_d();
        worldRenderer.func_181662_b((double)f4, (double)f5, (double)f7).func_187315_a((double)(0.0f + f8), (double)(f2 + f9)).func_181675_d();
        worldRenderer.func_181662_b((double)f4, (double)f6, (double)f7).func_187315_a((double)(0.0f + f8), (double)(0.0f + f9)).func_181675_d();
        worldRenderer.func_181662_b((double)f3, (double)f6, (double)f7).func_187315_a((double)(f2 + f8), (double)(0.0f + f9)).func_181675_d();
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderFootprints(float partialTicks) {
        FootprintRenderer.renderFootprints((EntityPlayer)ClientProxyCore.mc.field_71439_g, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)new ClientProxyCore.EventSpecialRender(partialTicks));
        BubbleRenderer.renderBubbles((EntityPlayer)ClientProxyCore.mc.field_71439_g, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public static double getCameraZoom(double previous) {
        if (ConfigManagerCore.disableVehicleCameraChanges) {
            return previous;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof ICameraZoomEntity) {
            return ((ICameraZoomEntity)player.func_184187_bx()).getCameraZoom();
        }
        return previous;
    }

    public static double armorDamageHook(EntityLivingBase entity) {
        ItemStack shield;
        GCPlayerStats stats;
        if (entity instanceof EntityPlayer && (stats = GCPlayerStats.get((Entity)entity)) != null && (shield = stats.getShieldControllerInSlot()) != null && !shield.func_190926_b() && shield.func_77973_b() == VenusItems.basicItem && shield.func_77952_i() == 0) {
            return 0.0;
        }
        return 1.0;
    }

    public static void setCurrentBuffer(BufferBuilder buffer) {
        renderBuilder.set(buffer);
    }

    public static boolean isGrating(boolean orig, Block b) {
        return orig || b instanceof BlockGrating && b != GCBlocks.grating && MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT;
    }

    public static float armorDamageHookF(EntityLivingBase entity) {
        return (float)TransformerHooks.armorDamageHook(entity);
    }

    @SideOnly(value=Side.CLIENT)
    public static int addRainParticles(int result, int rendererUpdateCount, float f) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (result == 0 || !(world.field_73011_w instanceof IWeatherProvider)) {
            return result;
        }
        IWeatherProvider moddedProvider = (IWeatherProvider)world.field_73011_w;
        random.setSeed((long)rendererUpdateCount * 312987231L);
        Entity entity = mc.func_175606_aa();
        BlockPos blockpos = new BlockPos(entity);
        int i = 10;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xx = 0.0;
        double yy = 0.0;
        double zz = 0.0;
        int j = 0;
        int k = (int)(100.0f * f * f);
        if (mc.field_71474_y.field_74362_aa == 1) {
            k >>= 1;
        } else if (mc.field_71474_y.field_74362_aa == 2) {
            k = 0;
        }
        for (int l = 0; l < k; ++l) {
            BlockPos blockpos1 = world.func_175725_q(blockpos.func_177982_a(random.nextInt(i) - random.nextInt(i), 0, random.nextInt(i) - random.nextInt(i)));
            Biome biome = world.func_180494_b(blockpos1);
            if (blockpos1.func_177956_o() > blockpos.func_177956_o() + i || blockpos1.func_177956_o() < blockpos.func_177956_o() - i) continue;
            double xd = random.nextDouble();
            double zd = random.nextDouble();
            BlockPos blockpos2 = blockpos1.func_177977_b();
            IBlockState iblockstate = world.func_180495_p(blockpos2);
            AxisAlignedBB axisalignedbb = iblockstate.func_185900_c((IBlockAccess)world, blockpos2);
            if (iblockstate.func_185904_a() != Material.field_151587_i && iblockstate.func_177230_c() != Blocks.field_189877_df) {
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                x = (double)blockpos2.func_177958_n() + xd;
                y = (double)blockpos2.func_177956_o() + 0.1 + axisalignedbb.field_72337_e;
                z = (double)blockpos2.func_177952_p() + zd;
                if (random.nextInt(++j) == 0) {
                    xx = x;
                    yy = y - 1.0;
                    zz = z;
                }
                mc.field_71452_i.func_78873_a(moddedProvider.getParticle(mc.field_71441_e, x, y, z));
                continue;
            }
            mc.field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)blockpos1.func_177958_n() + xd, (double)blockpos1.func_177956_o() + 0.1 - axisalignedbb.field_72338_b, (double)blockpos1.func_177952_p() + zd, 0.0, 0.0, 0.0, new int[0]);
        }
        if (moddedProvider.getSoundInterval(f) > 0) {
            if (j > 0 && random.nextInt(moddedProvider.getSoundInterval(f)) < rainSoundCounter++) {
                rainSoundCounter = 0;
                moddedProvider.weatherSounds(j, mc, (World)world, blockpos, xx, yy, zz, random);
            }
        } else if (j > 0 && 0 < rainSoundCounter++) {
            rainSoundCounter = 0;
            moddedProvider.weatherSounds(j, mc, (World)world, blockpos, xx, yy, zz, random);
        }
        return 0;
    }
}

