/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityArclamp;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBrightLamp
extends BlockAdvanced
implements IShiftDescription,
ITileEntityProvider,
ISortableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.6f, (double)0.8f);
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB((double)0.2f, (double)0.4f, (double)0.2f, (double)0.8f, 1.0, (double)0.8f);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB((double)0.2f, (double)0.2f, 0.0, (double)0.8f, (double)0.8f, (double)0.6f);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.4f, (double)0.8f, (double)0.8f, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, (double)0.2f, (double)0.2f, (double)0.6f, (double)0.8f, (double)0.8f);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB((double)0.4f, (double)0.2f, (double)0.2f, 1.0, (double)0.8f, (double)0.8f);

    public BlockBrightLamp(String assetName) {
        super(Material.field_151592_s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
        this.func_149715_a(0.9f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return UP_AABB;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block != this) {
            return block.func_149750_m(state);
        }
        if (world instanceof World) {
            return RedstoneUtil.isBlockReceivingRedstone((World)world, pos) ? 0 : this.field_149784_t;
        }
        return 0;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 1;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        double boundsMin = 0.2;
        double boundsMax = 0.8;
        return new AxisAlignedBB((double)pos.func_177958_n() + boundsMin, (double)pos.func_177956_o() + boundsMin, (double)pos.func_177952_p() + boundsMin, (double)pos.func_177958_n() + boundsMax, (double)pos.func_177956_o() + boundsMax, (double)pos.func_177952_p() + boundsMax);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos offsetPos = pos.func_177972_a(side);
            IBlockState state = worldIn.func_180495_p(offsetPos);
            BlockFaceShape faceShape = state.func_193401_d((IBlockAccess)worldIn, offsetPos, side.func_176734_d());
            if (!faceShape.equals((Object)BlockFaceShape.SOLID)) continue;
            return true;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = facing.func_176734_d();
        BlockPos offsetPos = pos.func_177972_a(opposite);
        IBlockState state = world.func_180495_p(offsetPos);
        BlockFaceShape faceShape = state.func_193401_d((IBlockAccess)world, offsetPos, facing);
        if (faceShape.equals((Object)BlockFaceShape.SOLID)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)opposite);
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos offsetPos = pos.func_177972_a(side);
        IBlockState state1 = worldIn.func_180495_p(offsetPos);
        BlockFaceShape faceShape = state1.func_193401_d((IBlockAccess)worldIn, offsetPos, EnumFacing.func_82600_a((int)(side.func_176745_a() ^ 1)));
        if (faceShape.equals((Object)BlockFaceShape.SOLID)) {
            return;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityArclamp) {
            ((TileEntityArclamp)tile).facingChanged();
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityArclamp();
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

