/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IFuelable;
import micdoodle8.mods.galacticraft.api.entity.ILandable;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLandingPad
extends TileEntityMulti
implements IMultiBlock,
IFuelable,
IFuelDock,
ICargoEntity {
    private IDockable dockedEntity;
    private boolean initialised;

    public TileEntityLandingPad() {
        super(null);
    }

    public void func_73660_a() {
        if (!this.initialised) {
            if (!this.field_145850_b.field_72995_K) {
                this.onCreate(this.field_145850_b, this.func_174877_v());
            }
            this.initialiseMultiTiles(this.func_174877_v(), this.field_145850_b);
            this.initialised = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            List list = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() - 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 0.5));
            boolean docked = false;
            for (Object o : list) {
                IDockable fuelable;
                if (!(o instanceof IDockable) || ((Entity)o).field_70128_L || (fuelable = (IDockable)o).inFlight()) continue;
                docked = true;
                if (fuelable == this.dockedEntity || !fuelable.isDockValid(this)) break;
                if (fuelable instanceof ILandable) {
                    ((ILandable)fuelable).landEntity(this.func_174877_v());
                    break;
                }
                fuelable.setPad(this);
                break;
            }
            if (!docked) {
                this.dockedEntity = null;
            }
        }
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public void onCreate(World world, BlockPos placedPosition) {
        this.mainBlockPosition = placedPosition;
        this.func_70296_d();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(placedPosition, positions);
        ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(world, positions, placedPosition, this.getMultiType());
    }

    @Override
    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.ROCKET_PAD;
    }

    @Override
    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int y = placedPosition.func_177956_o();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0) continue;
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != GCBlocks.fakeBlock || stateAt.func_177229_b(BlockMulti.MULTI_TYPE) != BlockMulti.EnumBlockMultiType.ROCKET_PAD) continue;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, this.field_145850_b.func_180495_p(pos));
            }
            this.field_145850_b.func_175655_b(pos, false);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
        if (this.dockedEntity != null) {
            this.dockedEntity.onPadDestroyed();
            this.dockedEntity = null;
        }
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doFill) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.addFuel(liquid, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack removeFuel(int amount) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.removeFuel(amount);
        }
        return null;
    }

    @Override
    public HashSet<ILandingPadAttachable> getConnectedTiles() {
        HashSet<ILandingPadAttachable> connectedTiles = new HashSet<ILandingPadAttachable>();
        for (int x = this.func_174877_v().func_177958_n() - 1; x < this.func_174877_v().func_177958_n() + 2; ++x) {
            this.testConnectedTile(x, this.func_174877_v().func_177952_p() - 2, connectedTiles);
            this.testConnectedTile(x, this.func_174877_v().func_177952_p() + 2, connectedTiles);
        }
        for (int z = this.func_174877_v().func_177952_p() - 1; z < this.func_174877_v().func_177952_p() + 2; ++z) {
            this.testConnectedTile(this.func_174877_v().func_177958_n() - 2, z, connectedTiles);
            this.testConnectedTile(this.func_174877_v().func_177958_n() + 2, z, connectedTiles);
        }
        return connectedTiles;
    }

    private void testConnectedTile(int x, int z, HashSet<ILandingPadAttachable> connectedTiles) {
        BlockPos testPos = new BlockPos(x, this.func_174877_v().func_177956_o(), z);
        if (!this.field_145850_b.func_175668_a(testPos, false)) {
            return;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(testPos);
        if (tile instanceof ILandingPadAttachable && ((ILandingPadAttachable)tile).canAttachToLandingPad((IBlockAccess)this.field_145850_b, this.func_174877_v())) {
            connectedTiles.add((ILandingPadAttachable)tile);
            if (tile instanceof TileEntityLaunchController) {
                ((TileEntityLaunchController)tile).setAttachedPad(this);
            }
        }
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.addCargo(stack, doAdd);
        }
        return ICargoEntity.EnumCargoLoadingState.NOTARGET;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.removeCargo(doRemove);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.NOTARGET, ItemStack.field_190927_a);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)this.func_174877_v().func_177956_o() + 0.4, (double)(this.func_174877_v().func_177952_p() + 2));
    }

    @Override
    public boolean isBlockAttachable(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ILandingPadAttachable) {
            return ((ILandingPadAttachable)tile).canAttachToLandingPad(world, this.func_174877_v());
        }
        return false;
    }

    @Override
    public IDockable getDockedEntity() {
        return this.dockedEntity;
    }

    @Override
    public void dockEntity(IDockable entity) {
        this.dockedEntity = entity;
    }
}

