/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerUtil {
    public static HashMap<String, GameProfile> knownSkins = new HashMap();

    public static EntityPlayerMP getPlayerForUsernameVanilla(MinecraftServer server, String username) {
        return server.func_184103_al().func_152612_a(username);
    }

    public static EntityPlayerMP getPlayerBaseServerFromPlayerUsername(String username, boolean ignoreCase) {
        MinecraftServer server = GCCoreUtil.getServer();
        return PlayerUtil.getPlayerBaseServerFromPlayerUsername(server, username, ignoreCase);
    }

    public static EntityPlayerMP getPlayerBaseServerFromPlayerUsername(MinecraftServer server, String username, boolean ignoreCase) {
        if (server != null) {
            EntityPlayerMP entityplayermp;
            if (ignoreCase) {
                return PlayerUtil.getPlayerForUsernameVanilla(server, username);
            }
            Iterator iterator = server.func_184103_al().func_181057_v().iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!(entityplayermp = (EntityPlayerMP)iterator.next()).func_70005_c_().equalsIgnoreCase(username));
            return entityplayermp;
        }
        GalacticraftCore.logger.error("Warning: Could not find player base server instance for player " + username, new Object[0]);
        return null;
    }

    public static EntityPlayerMP getPlayerBaseServerFromPlayer(EntityPlayer player, boolean ignoreCase) {
        if (player == null) {
            return null;
        }
        if (player instanceof EntityPlayerMP) {
            return (EntityPlayerMP)player;
        }
        return PlayerUtil.getPlayerBaseServerFromPlayerUsername(player.func_70005_c_(), ignoreCase);
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayerSP getPlayerBaseClientFromPlayer(EntityPlayer player, boolean ignoreCase) {
        EntityPlayerSP clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
        if (clientPlayer == null && player != null) {
            GalacticraftCore.logger.error("Warning: Could not find player base client instance for player " + PlayerUtil.getName(player), new Object[0]);
        }
        return clientPlayer;
    }

    @SideOnly(value=Side.CLIENT)
    public static GameProfile getOtherPlayerProfile(String name) {
        return knownSkins.get(name);
    }

    @SideOnly(value=Side.CLIENT)
    public static GameProfile makeOtherPlayerProfile(String strName, String strUUID) {
        GameProfile profile = null;
        for (Object e : FMLClientHandler.instance().getWorldClient().func_72910_y()) {
            GameProfile gp2;
            if (!(e instanceof AbstractClientPlayer) || !(gp2 = ((AbstractClientPlayer)e).func_146103_bH()).getName().equals(strName)) continue;
            profile = gp2;
            break;
        }
        if (profile == null) {
            UUID uuid = strUUID.isEmpty() ? UUID.randomUUID() : UUID.fromString(strUUID);
            profile = new GameProfile(uuid, strName);
        }
        knownSkins.put(strName, profile);
        return profile;
    }

    @SideOnly(value=Side.CLIENT)
    public static GameProfile getSkinForName(String strName, String strUUID, int dimID) {
        GameProfile profile = FMLClientHandler.instance().getClientPlayerEntity().func_146103_bH();
        if (!strName.equals(profile.getName())) {
            profile = PlayerUtil.getOtherPlayerProfile(strName);
            if (profile == null) {
                profile = PlayerUtil.makeOtherPlayerProfile(strName, strUUID);
            }
            if (!profile.getProperties().containsKey((Object)"textures")) {
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_PLAYERSKIN, dimID, new Object[]{strName}));
            }
        }
        return profile;
    }

    public static EntityPlayerMP getPlayerByUUID(UUID theUUID) {
        List<EntityPlayerMP> players = PlayerUtil.getPlayersOnline();
        for (int i = players.size() - 1; i >= 0; --i) {
            EntityPlayerMP entityplayermp = players.get(i);
            if (!entityplayermp.func_110124_au().equals(theUUID)) continue;
            return entityplayermp;
        }
        return null;
    }

    public static List<EntityPlayerMP> getPlayersOnline() {
        return GCCoreUtil.getServer().func_184103_al().func_181057_v();
    }

    public static boolean isPlayerOnline(EntityPlayerMP player) {
        return player.field_71133_b.func_184103_al().func_181057_v().contains(player);
    }

    public static String getName(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        if (player.func_146103_bH() == null) {
            return null;
        }
        return player.func_146103_bH().getName();
    }
}

