/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender;

import com.github.ipixeli.gender.Logger;
import com.github.ipixeli.gender.PacketHandler;
import com.github.ipixeli.gender.common.GenderCommon;
import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.Mod;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.server.GenderServer;
import java.io.File;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@net.minecraftforge.fml.common.Mod(modid="gender")
public final class GenderForge
implements Mod {
    public static final String MC = "1.12.2";
    public static final String VER = "2";
    public static final String version = "1.7.0 (1.12.2 v2)";
    private static GenderForge instance;
    public static final Logger logger;
    @SidedProxy(clientSide="com.github.ipixeli.gender.client.GenderClient", serverSide="com.github.ipixeli.gender.common.GenderCommon")
    public static GenderCommon proxy;
    private static File modDir;

    public GenderForge() {
        instance = this;
        new Gender(this, logger);
        logger.logInfo("Gender is version 1.7.0 (1.12.2 v2)Environment Version is FORGE " + ForgeVersion.getVersion());
    }

    public static GenderForge get() {
        return instance;
    }

    private static File checkSetupDirsAndConfig(File cwd) {
        File modDir = new File(cwd + "/gender/");
        if (!modDir.exists()) {
            logger.logWarn("Unable to locate missing folder(s): " + modDir.getAbsolutePath());
            if (modDir.mkdirs()) {
                logger.logWarn("Successfully created missing folder(s): " + modDir.getAbsolutePath());
            }
        }
        return modDir;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        modDir = GenderForge.checkSetupDirsAndConfig(e.getModConfigurationDirectory());
        proxy.preInit(modDir);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent e) {
        proxy.onInit(modDir);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        FMLEventChannel packetHandler = NetworkRegistry.INSTANCE.newEventDrivenChannel("gender");
        packetHandler.register((Object)new PacketHandler(packetHandler));
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverSetup(FMLServerStartingEvent e) {
        if (modDir == null) {
            modDir = GenderForge.checkSetupDirsAndConfig(e.getServer().func_71238_n());
        }
        GenderServer.onSetup(modDir, e.getServer(), e);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void sendProfilePacket(PlayerProfile p) {
        PacketHandler.sendProfileFromClientToServer(p);
    }

    static {
        logger = new Logger();
    }
}

